package com.ximai.mes.md.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;
 
/**
 * 产品SOP对象 md_produt_sop
 *
 * @date 2022-07-26
 */
@Data
public class MdProductSop extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 记录ID
     */
    private Long sopId;

    /**
     * 物料产品ID
     */
    @Excel(name = "物料产品ID")
    private Long itemId;

    /**
     * 排列顺序
     */
    @Excel(name = "排列顺序")
    private Integer orderNum;

    /**
     * 对应的工序
     */
    @Excel(name = "对应的工序")
    private Long processId;

    /**
     * 工序编号
     */
    @Excel(name = "工序编号")
    private String processCode;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    /**
     * 标题
     */
    @Excel(name = "标题")
    private String sopTitle;

    /**
     * 详细描述
     */
    @Excel(name = "详细描述")
    private String sopDescription;

    /**
     * 图片地址
     */
    @Excel(name = "图片地址")
    private String sopUrl;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

}
