package com.ximai.web.controller.monitor;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.system.domain.SysApiLog;
import com.ximai.system.service.ISysApiLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 操作日志记录
 *
 */
@RestController
@RequestMapping("/monitor/apiLog")
public class SysApiLogController extends BaseController
{
    @Autowired
    private ISysApiLogService operLogService;

    @PreAuthorize("@ss.hasPermi('monitor:apilog:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysApiLog operLog)
    {
        startPage();
        List<SysApiLog> list = operLogService.selectApiLogList(operLog);
        return getDataTable(list);
    }

    @Log(title = "操作日志", businessType = BusinessType.DELETE)
    @PreAuthorize("@ss.hasPermi('monitor:apilog:remove')")
    @DeleteMapping("/{operIds}")
    public AjaxResult remove(@PathVariable Long[] operIds)
    {
        return toAjax(operLogService.deleteApiLogByIds(operIds));
    }

    @Log(title = "操作日志", businessType = BusinessType.CLEAN)
    @PreAuthorize("@ss.hasPermi('monitor:apilog:remove')")
    @DeleteMapping("/clean")
    public AjaxResult clean()
    {
        operLogService.cleanApiLog();
        return AjaxResult.success();
    }
}
