package com.ximai.system.service;

import java.util.List;
import com.ximai.system.domain.SysPrintPrinterConfig;

/**
 * 打印机配置Service接口
 *
 * @author generator
 * @date 2024-02-28
 */
public interface ISysPrintPrinterConfigService
{
    /**
     * 查询打印机配置
     *
     * @param printerId 打印机配置主键
     * @return 打印机配置
     */
    public SysPrintPrinterConfig selectSysPrintPrinterConfigByPrinterId(Long printerId);

    /**
     * 查询打印机配置列表
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 打印机配置集合
     */
    public List<SysPrintPrinterConfig> selectSysPrintPrinterConfigList(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 新增打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    public int insertSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 修改打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    public int updateSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 批量删除打印机配置
     *
     * @param printerIds 需要删除的打印机配置主键集合
     * @return 结果
     */
    public int deleteSysPrintPrinterConfigByPrinterIds(Long[] printerIds);

    /**
     * 删除打印机配置信息
     *
     * @param printerId 打印机配置主键
     * @return 结果
     */
    public int deleteSysPrintPrinterConfigByPrinterId(Long printerId);

}
