package com.ximai.mes.pro.service.impl.prototypeRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.vo.ProPrototypeRequestProcessQcindexVo;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestProcessQcindexMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessQcindex;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessQcindexService;

/**
 * 打样申请工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProPrototypeRequestProcessQcindexServiceImpl implements IProPrototypeRequestProcessQcindexService
{
    @Autowired
    private ProPrototypeRequestProcessQcindexMapper proPrototypeRequestProcessQcindexMapper;
    @Autowired
    private QcIndexMapper qcIndexMapper;

    /**
     * 查询打样申请工序检验项
     *
     * @param prototypeRequestProcessQcindexId 打样申请工序检验项主键
     * @return 打样申请工序检验项
     */
    @Override
    public ProPrototypeRequestProcessQcindex selectProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(Long prototypeRequestProcessQcindexId)
    {
        return proPrototypeRequestProcessQcindexMapper.selectProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(prototypeRequestProcessQcindexId);
    }

    /**
     * 查询打样申请工序检验项列表
     *
     * @param proPrototypeRequestProcessQcindex 打样申请工序检验项
     * @return 打样申请工序检验项
     */
    @Override
    public List<ProPrototypeRequestProcessQcindex> selectProPrototypeRequestProcessQcindexList(ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        return proPrototypeRequestProcessQcindexMapper.selectProPrototypeRequestProcessQcindexList(proPrototypeRequestProcessQcindex);
    }

    @Override
    public List<ProPrototypeRequestProcessQcindexVo> selectProPrototypeRequestProcessQcindexVoList(ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        List<ProPrototypeRequestProcessQcindexVo> rst = new ArrayList<ProPrototypeRequestProcessQcindexVo>();
        ProPrototypeRequestProcessQcindex query = new ProPrototypeRequestProcessQcindex();
        query.setPrototypeRequestId(proPrototypeRequestProcessQcindex.getPrototypeRequestId());
        List<ProPrototypeRequestProcessQcindex> list = proPrototypeRequestProcessQcindexMapper.selectProPrototypeRequestProcessQcindexList(query);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            ProPrototypeRequestProcessQcindexVo vo = new ProPrototypeRequestProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样申请工序检验项
     *
     * @param proPrototypeRequestProcessQcindex 打样申请工序检验项
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequestProcessQcindex(ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        return proPrototypeRequestProcessQcindexMapper.insertProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex);
    }

    /**
     * 修改打样申请工序检验项
     *
     * @param proPrototypeRequestProcessQcindex 打样申请工序检验项
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequestProcessQcindex(ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        return proPrototypeRequestProcessQcindexMapper.updateProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex);
    }

    /**
     * 批量删除打样申请工序检验项
     *
     * @param prototypeRequestProcessQcindexIds 需要删除的打样申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexIds(Long[] prototypeRequestProcessQcindexIds)
    {
        return proPrototypeRequestProcessQcindexMapper.deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexIds(prototypeRequestProcessQcindexIds);
    }

    /**
     * 删除打样申请工序检验项信息
     *
     * @param prototypeRequestProcessQcindexId 打样申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(Long prototypeRequestProcessQcindexId)
    {
        return proPrototypeRequestProcessQcindexMapper.deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(prototypeRequestProcessQcindexId);
    }
}
