package com.ximai.mes.pro.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeBom;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/22
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProPrototypeMakeVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 样品制作单ID */
    private Long prototypeMakeId;

    /** 样品制作单编码 */
    @Excel(name = "样品制作单编码")
    private String prototypeMakeCode;

    /** 样品申请单ID */
    @Excel(name = "样品申请单ID")
    private Long prototypeRequestId;

    /** 工艺路线ID */
    @Excel(name = "工艺路线ID")
    private Long routeId;

    /** 工艺路线名称 */
    @Excel(name = "工艺路线名称")
    private  String routeName;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 产品名称 */
    @Excel(name = "产品名称")
    private String itemName;

    /** 网版目数 */
    @Excel(name = "网版目数")
    private String screenItem;

    /** 啤版目数 */
    @Excel(name = "啤版目数")
    private String pibanItem;

    /** 模切版目数 */
    @Excel(name = "模切版目数")
    private String diecuttingItem;

    /** 标准色号 */
    @Excel(name = "标准色号")
    private String standardColor;

    /** 模数 */
    @Excel(name = "模数")
    private String module;

    /** 列 */
    @Excel(name = "列")
    private Long colNum;

    /** 行 */
    @Excel(name = "行")
    private Long rowNum;

    /** 搭板数 */
    @Excel(name = "搭板数")
    private Long buttstrapNum;

    /** 列双刀位 */
    @Excel(name = "列双刀位")
    private String coldoubleCutspacing;

    /** 行双刀位 */
    @Excel(name = "行双刀位")
    private String rowdoubleCutspacing;

    /** 派工倍数 */
    @Excel(name = "派工倍数")
    private Long sendworkMultiple;

    /** 印张长度 */
    @Excel(name = "印张长度")
    private BigDecimal printingPaperlenth;

    /** 印张宽度 */
    @Excel(name = "印张宽度")
    private BigDecimal printPaperwidth;

    /** 印刷正面颜色 */
    @Excel(name = "印刷正面颜色")
    private Long frontColorId;

    private String frontColorName;

    /** 样品申请单编码 */
    private String prototypeRequestCode;

    /** 简称 */
    private String abbreviation;

    /** 样品英文名称 */
    private String enName;

    /** 样品数量 */
    private Long num;

    /** 打样形式 */
    private String type;

    /** 分配方式 */
    private String modality;

    /** 表面处理 */
    private String surfaceTreatment;

    /** 印刷反面颜色 */
    @Excel(name = "印刷反面颜色")
    private Long oppositeColorId;

    private String oppositeColorName;

    /** NG原因 */
    @Excel(name = "NG原因")
    private String ngReason;

    private int prototypeMakeStatus;

    /** 计划完成日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划完成日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedFinishDate;

    /** 版面需求时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "版面需求时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedLayoutDate;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 备注 */
    private String remark;

    /** Bom列表 */
    private List<ProPrototypeMakeBom> bomList;

    /** 工序列表 */
    private List<ProPrototypeMakeProcessVo> processList;

    /** 长;单位cm */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /** 宽;单位cm */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /** 高;单位cm */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /** 厚度;单位mm */
    @Excel(name = "厚度;单位mm")
    private BigDecimal thick;

    /** 成品克重;单位g */
    @Excel(name = "成品克重;单位g")
    private BigDecimal weight;

    /** 角型 */
    @Excel(name = "角型")
    private String angleType;

    /**是否异型**/
    private String isAllotype;

    /**是否直角**/
    private String isRightAngle;

    /**圆角**/
    private BigDecimal fillet;

    /** 角度(单位mm) */
    @Excel(name = "角度(单位mm)")
    private BigDecimal angle;

    /** 孔径(单位mm) */
    @Excel(name = "孔径(单位mm)")
    private BigDecimal aperture;

    /** 单层厚(单位丝) */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /** 单重(单位KG) */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /** 层数 */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /** 是否防霉(is_open) */
    @Excel(name = "是否防霉(is_open)")
    private String isMould;

    /** 是否写码(is_open) */
    @Excel(name = "是否写码(is_open)")
    private String isCoding;

    /** 体系认证(product_sys_certification) */
    @Excel(name = "体系认证(product_sys_certification)")
    private String certification;

    /** 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角； */
    @Excel(name = "样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；")
    private String shape;

    /** 样品形状大小（mm） */
    @Excel(name = "样品形状大小", readConverterExp = "m=m")
    private BigDecimal shapeSize;

    /** 产品正面 */
    @Excel(name = "产品正面")
    private String frontImg;

    /** 产品背面 */
    @Excel(name = "产品背面")
    private String backImg;

}
