package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 调拨料申请对象 pro_allocation_material
 *
 * @author generator
 * @date 2024-05-14
 */


@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class ProAllocationMaterialVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    @TableId
    private Long allocationMaterialId;

    /** 申请单号 */
    @Excel(name = "调拨申请单号")
    private String applyNo;

    /** 任务单号 */
    @Excel(name = "任务单号")
    private Long taskId;

    /** 创建方式 */
    @Excel(name = "创建方式")
    private Long buildMethod;

    /** 任务单编码 */
    @Excel(name = "任务单编码")
    private String taskCode;

    /** 已调拨料 */
    @Excel(name = "已调拨料")
    private BigDecimal allocationNum;

    /** 是的结案 */
    @Excel(name = "是的结案")
    private String windCase;

    /**
     * 领料类型
     */
    @Excel(name = "领料类型")
    private Long materialType;

    /** 需求日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 需求日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;


    /** 物料信息 */
    @Excel(name = "物料信息")
    private List<ProAllocationItemList> itemList;

}
