package com.ximai;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.SpringVersion;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;


@Component
@Slf4j
public class PrintEnvParameter implements CommandLineRunner {

    @Value("${spring.application.name}")
    private String name;
 
    @Value("${server.port}")
    private Integer port;

    @Resource
    private ConfigurableEnvironment springEnv;

    @Override
    public void run(String... args) throws Exception {
        MutablePropertySources propSrcs = springEnv.getPropertySources();
        // 获取所有配置
        Map<String, String> props = StreamSupport.stream(propSrcs.spliterator(), false)
                .filter(ps -> ps instanceof EnumerablePropertySource)
                .map(ps -> ((EnumerablePropertySource) ps).getPropertyNames())
                .flatMap(Arrays::stream)
                .distinct()
                .collect(Collectors.toMap(Function.identity(), springEnv::getProperty));

        // key 和 value 之间的最小间隙
        int interval = 20;
        int max = props.keySet().stream()
                .max(Comparator.comparingInt(String::length))
                .orElse("")
                .length();

        // 打印
        props.keySet().stream()
                .sorted()
                .forEach(k -> {
                    int i = max - k.length() + interval;
                    String join = String.join("", Collections.nCopies(i, " "));
                    System.out.println(String.format("%s: %s%s", k, join, props.get(k)));
                });

        log.info("{} 启动成功 , version: {} ,port: {} ", name, SpringVersion.getVersion(), port);
    }
}