package com.ximai.system.service.impl;

import java.util.List;

import cn.hutool.core.collection.CollUtil;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.system.mapper.SysUserAssocintionPrintMapper;
import com.ximai.system.domain.SysUserAssocintionPrint;
import com.ximai.system.service.ISysUserAssocintionPrintService;

/**
 * 人员关联打印机表Service业务层处理
 *
 * @author generator
 * @date 2024-03-16
 */
@Service
public class SysUserAssocintionPrintServiceImpl implements ISysUserAssocintionPrintService
{
    @Autowired
    private SysUserAssocintionPrintMapper sysUserAssocintionPrintMapper;

    /**
     * 查询人员关联打印机表
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 人员关联打印机表
     */
    @Override
    public SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintId(Long userPrintId)
    {
        return sysUserAssocintionPrintMapper.selectSysUserAssocintionPrintByUserPrintId(userPrintId);
    }

    /**
     * 查询人员关联打印机表列表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 人员关联打印机表
     */
    @Override
    public List<SysUserAssocintionPrint> selectSysUserAssocintionPrintList(SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        return sysUserAssocintionPrintMapper.selectSysUserAssocintionPrintList(sysUserAssocintionPrint);
    }

    /**
     * 新增人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    @Override
    public int insertSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        SysUserAssocintionPrint sysUserAssocintionPrint1 = new SysUserAssocintionPrint();
        sysUserAssocintionPrint1.setUserId(sysUserAssocintionPrint.getUserId());
        List<SysUserAssocintionPrint> UserAssocintionPrint1 = sysUserAssocintionPrintMapper.selectSysUserAssocintionPrintList(sysUserAssocintionPrint1);
        if(CollUtil.isNotEmpty(UserAssocintionPrint1)){
            UserAssocintionPrint1.forEach(c->{
                if(c.getPrinterName().equals(sysUserAssocintionPrint.getPrinterName())){
                    throw new ServiceException(MessageUtils.message("system.printer.error.repeat.bind"));
                }
                c.setStatus(1L);
                c.setPrinterId(sysUserAssocintionPrint.getPrinterId());
                c.setPrinterName(sysUserAssocintionPrint.getPrinterName());
                c.setUpdateBy(sysUserAssocintionPrint.getUserName());
                c.setUpdateTime(DateUtils.getNowDate());
                this.updateSysUserAssocintionPrint(c);
            });

            return 1;
        }else{
            sysUserAssocintionPrint.setStatus(1L);
            sysUserAssocintionPrint.setCreateBy(sysUserAssocintionPrint.getUserName());
            sysUserAssocintionPrint.setCreateTime(DateUtils.getNowDate());
            return sysUserAssocintionPrintMapper.insertSysUserAssocintionPrint(sysUserAssocintionPrint);
        }


    }

    /**
     * 修改人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    @Override
    public int updateSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        sysUserAssocintionPrint.setUpdateBy(SecurityUtils.getUsername());
        sysUserAssocintionPrint.setUpdateTime(DateUtils.getNowDate());
        return sysUserAssocintionPrintMapper.updateSysUserAssocintionPrint(sysUserAssocintionPrint);
    }

    /**
     * 批量删除人员关联打印机表
     *
     * @param userPrintIds 需要删除的人员关联打印机表主键
     * @return 结果
     */
    @Override
    public int deleteSysUserAssocintionPrintByUserPrintIds(Long[] userPrintIds)
    {
        return sysUserAssocintionPrintMapper.deleteSysUserAssocintionPrintByUserPrintIds(userPrintIds);
    }

    /**
     * 删除人员关联打印机表信息
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 结果
     */
    @Override
    public int deleteSysUserAssocintionPrintByUserPrintId(Long userPrintId)
    {
        return sysUserAssocintionPrintMapper.deleteSysUserAssocintionPrintByUserPrintId(userPrintId);
    }

    @Override
    public SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintIdUserId(Long userId) {
        return sysUserAssocintionPrintMapper.selectSysUserAssocintionPrintByUserPrintIdUserId(userId);
    }
}
