package com.ximai.mes.tm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.constant.TmToolMachineTypeEnum;
import com.ximai.mes.constant.TmToolStatusEnum;
import com.ximai.mes.constant.TmToolWarehouseType;
import com.ximai.mes.tm.domain.TmTool;
import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.domain.TmToolWarehouse;
import com.ximai.mes.tm.domain.TmToolWarehouseItem;
import com.ximai.mes.tm.mapper.TmToolMachinesMapper;
import com.ximai.mes.tm.mapper.TmToolMapper;
import com.ximai.mes.tm.mapper.TmToolWarehouseMapper;
import com.ximai.mes.tm.service.ITmToolMachinesService;
import com.ximai.mes.tm.service.ITmToolService;
import com.ximai.mes.tm.service.ITmToolWarehouseItemService;
import com.ximai.mes.tm.service.ITmToolWarehouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 刀模版入库Service业务层处理
 *
 * @author generator
 * @date 2024-03-07
 */
@Service
public class TmToolWarehouseServiceImpl implements ITmToolWarehouseService {
    @Autowired
    private TmToolWarehouseMapper tmToolWarehouseMapper;
    @Autowired
    private ITmToolWarehouseItemService tmToolWarehouseItemService;
    @Autowired
    private TmToolMapper tmToolMapper;

    @Autowired
    private ITmToolService iTmToolService;

    @Autowired
    private ITmToolMachinesService tmToolMachinesService;

    @Autowired
    private TmToolMachinesMapper tmToolMachinesMapper;

    /**
     * 查询刀模版入库
     *
     * @param toolWarehouseId 刀模版入库主键
     * @return 刀模版入库
     */
    @Override
    public TmToolWarehouse selectTmToolWarehouseByToolWarehouseId(Long toolWarehouseId) {
        TmToolWarehouse tmToolWarehouse = tmToolWarehouseMapper.selectTmToolWarehouseByToolWarehouseId(toolWarehouseId);
//        tmToolWarehouse.setWarehouseItemList(tmToolWarehouseItemMapper.selectTmToolWarehouseItemList(new TmToolWarehouseItem(toolWarehouseId)));
        return tmToolWarehouse;
    }

    /**
     * 查询刀模版入库列表
     *
     * @param tmToolWarehouse 刀模版入库
     * @return 刀模版入库
     */
    @Override
    public List<TmToolWarehouse> selectTmToolWarehouseList(TmToolWarehouse tmToolWarehouse) {
        return tmToolWarehouseMapper.selectTmToolWarehouseList(tmToolWarehouse);
    }

    @Override
    public int insertObj(TmToolWarehouse tmToolWarehouse) {
        List<TmToolWarehouseItem> tmToolWarehouseItemList = tmToolWarehouse.getWarehouseItemList();
        long count = tmToolWarehouseItemList.stream().filter(x ->
                !Arrays.asList(TmToolMachineTypeEnum.DIS_MOUNT.getType(), TmToolMachineTypeEnum.INIT.getType()).contains(x.getType()) || x.getWarehouse() == TmToolWarehouseType.ENTRY_WAREHOUSE).count();

        ExceptionUtil.checkTrueThrowException(count > 0, MessageUtils.message("pro.tool.error.error24"));
        long count2 = tmToolWarehouseItemList.stream().filter(x -> StringUtils.isEmpty(x.getWarehouseDesc())).count();
        ExceptionUtil.checkTrueThrowException(count2 > 0, MessageUtils.message("pro.tool.error.error25"));

        Set<String> toolCodes = tmToolWarehouseItemList.stream().map(TmToolWarehouseItem::getToolCode).collect(Collectors.toSet());
        List<TmTool> tmToolList = tmToolMapper.selectListByQw(new QueryWrapper<TmTool>().in("tool_code", toolCodes));

        Map<String, TmTool> toolMap = tmToolList.stream().collect(Collectors.toMap(TmTool::getToolCode, x -> x));
        List<TmToolMachines> tmToolMachines = tmToolMachinesMapper.selectListByQws(new QueryWrapper<TmToolMachines>().in("tt.tool_code", toolCodes));
        Map<String, List<TmToolMachines>> ttmMap = tmToolMachines.stream().collect(Collectors.groupingBy(TmToolMachines::getToolCode));

        int i = this.insertTmToolWarehouse(tmToolWarehouse);
        for (TmToolWarehouseItem tmToolWarehouseItem : tmToolWarehouseItemList) {
            tmToolWarehouseItem.setToolWarehouseId(tmToolWarehouse.getToolWarehouseId());
            tmToolWarehouseItemService.insertTmToolWarehouseItem(tmToolWarehouseItem);

            TmTool tmTool = toolMap.get(tmToolWarehouseItem.getToolCode());
            List<TmToolMachines> tmToolMachinesList = ttmMap.get(tmToolWarehouseItem.getToolCode());
            for (TmToolMachines machines : tmToolMachinesList) {
                machines.setWarehouse(TmToolWarehouseType.ENTRY_WAREHOUSE);
                tmToolMachinesService.updateTmToolMachines(machines);
            }

            String warehouseDesc = tmToolWarehouseItem.getWarehouseDesc();
            TmToolStatusEnum tmToolStatusEnum = TmToolStatusEnum.get(warehouseDesc);
            if (tmToolStatusEnum == TmToolStatusEnum.STORE) {
                tmTool.setStatus(TmToolStatusEnum.STORE.getStatus());
                tmTool.setQuantityAvail(1L);
            } else if (tmToolStatusEnum == TmToolStatusEnum.SCRAP) {
                tmTool.setStatus(TmToolStatusEnum.SCRAP.getStatus());
            }
            iTmToolService.updateTmTool(tmTool);

        }
        return i;
    }

    /**
     * 新增刀模版入库
     *
     * @param tmToolWarehouse 刀模版入库
     * @return 结果
     */
    @Override
    public int insertTmToolWarehouse(TmToolWarehouse tmToolWarehouse) {
        tmToolWarehouse.createAction();
        return tmToolWarehouseMapper.insertTmToolWarehouse(tmToolWarehouse);
    }

    /**
     * 修改刀模版入库
     *
     * @param tmToolWarehouse 刀模版入库
     * @return 结果
     */
    @Override
    public int updateTmToolWarehouse(TmToolWarehouse tmToolWarehouse) {
        tmToolWarehouse.updateAction();
        return tmToolWarehouseMapper.updateTmToolWarehouse(tmToolWarehouse);
    }

    /**
     * 批量删除刀模版入库
     *
     * @param toolWarehouseIds 需要删除的刀模版入库主键
     * @return 结果
     */
    @Override
    public int deleteTmToolWarehouseByToolWarehouseIds(Long[] toolWarehouseIds) {
        return tmToolWarehouseMapper.deleteTmToolWarehouseByToolWarehouseIds(toolWarehouseIds);
    }

    /**
     * 删除刀模版入库信息
     *
     * @param toolWarehouseId 刀模版入库主键
     * @return 结果
     */
    @Override
    public int deleteTmToolWarehouseByToolWarehouseId(Long toolWarehouseId) {
        return tmToolWarehouseMapper.deleteTmToolWarehouseByToolWarehouseId(toolWarehouseId);
    }
}
