package com.ximai.mes.tm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import com.ximai.mes.tm.domain.TmToolWarehouseItem;
import com.ximai.mes.tm.service.ITmToolWarehouseItemService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 *
 * @author generator
 * @date 2024-03-07
 */
@RestController
@RequestMapping("/md/warehouse/item")
public class TmToolWarehouseItemController extends BaseController {
    @Autowired
    private ITmToolWarehouseItemService tmToolWarehouseItemService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:item:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolWarehouseItem tmToolWarehouseItem) {
        startPage();
        List<TmToolWarehouseItem> list = tmToolWarehouseItemService.selectTmToolWarehouseItemList(tmToolWarehouseItem);
        return getDataTable(list);
    }


    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:item:query')")
    @GetMapping(value = "/{toolWarehouseItemId}")
    public AjaxResult getInfo(@PathVariable("toolWarehouseItemId") Long toolWarehouseItemId) {
        return AjaxResult.success(tmToolWarehouseItemService.selectTmToolWarehouseItemByToolWarehouseItemId(toolWarehouseItemId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolWarehouseItem tmToolWarehouseItem) {
        return toAjax(tmToolWarehouseItemService.insertTmToolWarehouseItem(tmToolWarehouseItem));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolWarehouseItem tmToolWarehouseItem) {
        return toAjax(tmToolWarehouseItemService.updateTmToolWarehouseItem(tmToolWarehouseItem));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolWarehouseItemIds}")
    public AjaxResult remove(@PathVariable Long[] toolWarehouseItemIds) {
        return toAjax(tmToolWarehouseItemService.deleteTmToolWarehouseItemByToolWarehouseItemIds(toolWarehouseItemIds));
    }
}
