package com.ximai.mes.pro.service.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeBom;

/**
 * 样品制作BOMService接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface IProPrototypeMakeBomService
{
    /**
     * 查询样品制作BOM
     *
     * @param bomItemId 样品制作BOM主键
     * @return 样品制作BOM
     */
    public ProPrototypeMakeBom selectProPrototypeMakeBomByBomItemId(Long bomItemId);

    /**
     * 查询样品制作BOM列表
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 样品制作BOM集合
     */
    public List<ProPrototypeMakeBom> selectProPrototypeMakeBomList(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 新增样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    public int insertProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 修改样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    public int updateProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 批量删除样品制作BOM
     *
     * @param bomItemIds 需要删除的样品制作BOM主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeBomByBomItemIds(Long[] bomItemIds);

    /**
     * 删除样品制作BOM信息
     *
     * @param bomItemId 样品制作BOM主键
     * @return 结果
     */
    public int deleteProPrototypeMakeBomByBomItemId(Long bomItemId);
}
