package com.ximai.mes.pro.service.impl.task;

import java.util.List;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.mes.pro.domain.ProFeedback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.task.ProFdQrcodePrintRecordMapper;
import com.ximai.mes.pro.domain.task.ProFdQrcodePrintRecord;
import com.ximai.mes.pro.service.task.IProFdQrcodePrintRecordService;

/**
 * 报工打印二维码记录表Service业务层处理
 *
 * @author generator
 * @date 2024-03-19
 */
@Service
public class ProFdQrcodePrintRecordServiceImpl implements IProFdQrcodePrintRecordService
{
    @Autowired
    private ProFdQrcodePrintRecordMapper proFdQrcodePrintRecordMapper;

    /**
     * 查询报工打印二维码记录表
     *
     * @param recordId 报工打印二维码记录表主键
     * @return 报工打印二维码记录表
     */
    @Override
    public ProFdQrcodePrintRecord selectProFdQrcodePrintRecordByRecordId(Long recordId)
    {
        return proFdQrcodePrintRecordMapper.selectProFdQrcodePrintRecordByRecordId(recordId);
    }

    /**
     * 查询报工打印二维码记录表列表
     *
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 报工打印二维码记录表
     */
    @Override
    public List<ProFdQrcodePrintRecord> selectProFdQrcodePrintRecordList(ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        return proFdQrcodePrintRecordMapper.selectProFdQrcodePrintRecordList(proFdQrcodePrintRecord);
    }

    /**
     * 新增报工打印二维码记录表
     *
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 结果
     */
    @Override
    public int insertProFdQrcodePrintRecord(ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        proFdQrcodePrintRecord.setCreateBy(SecurityUtils.getUsername());
        proFdQrcodePrintRecord.setCreateTime(DateUtils.getNowDate());
        return proFdQrcodePrintRecordMapper.insertProFdQrcodePrintRecord(proFdQrcodePrintRecord);
    }

    /**
     * 修改报工打印二维码记录表
     *
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 结果
     */
    @Override
    public int updateProFdQrcodePrintRecord(ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        return proFdQrcodePrintRecordMapper.updateProFdQrcodePrintRecord(proFdQrcodePrintRecord);
    }

    /**
     * 批量删除报工打印二维码记录表
     *
     * @param recordIds 需要删除的报工打印二维码记录表主键
     * @return 结果
     */
    @Override
    public int deleteProFdQrcodePrintRecordByRecordIds(Long[] recordIds)
    {
        return proFdQrcodePrintRecordMapper.deleteProFdQrcodePrintRecordByRecordIds(recordIds);
    }

    /**
     * 删除报工打印二维码记录表信息
     *
     * @param recordId 报工打印二维码记录表主键
     * @return 结果
     */
    @Override
    public int deleteProFdQrcodePrintRecordByRecordId(Long recordId)
    {
        return proFdQrcodePrintRecordMapper.deleteProFdQrcodePrintRecordByRecordId(recordId);
    }

    @Override
    public void insertProFdQrcodePrintRecordfeedback(ProFeedback feedback) {
        ProFdQrcodePrintRecord proFdQrcodePrintRecord = new ProFdQrcodePrintRecord();
        proFdQrcodePrintRecord.setTaskWorkunitId(feedback.getTaskWorkunitId());
        proFdQrcodePrintRecord.setWorkorderId(feedback.getWorkorderId());
        proFdQrcodePrintRecord.setBarcode(feedback.getPrintContents());
        proFdQrcodePrintRecord.setCreateBy(SecurityUtils.getUsername());
        proFdQrcodePrintRecord.setCreateTime(DateUtils.getNowDate());
        this.insertProFdQrcodePrintRecord(proFdQrcodePrintRecord);
    }


}
