package com.ximai.mes.pro.service.impl.proWorkOrder;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ProWorkOrderSoSizeItemDynamic;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderSoSizeItemMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderSoSizeItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 生产工单尺码Service业务层处理
 *
 * @author zht
 * @date 2024-02-29
 */
@Service
public class ProWorkOrderSoSizeItemServiceImpl implements IProWorkOrderSoSizeItemService {
    @Autowired
    private ProWorkOrderSoSizeItemMapper proWorkOrderSoSizeItemMapper;

    /**
     * 查询生产工单尺码
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 生产工单尺码
     */
    @Override
    public ProWorkOrderSoSizeItem selectProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId) {
        return proWorkOrderSoSizeItemMapper.selectProWorkOrderSoSizeItemByWorkorderSoSizeItemId(workorderSoSizeItemId);
    }

    /**
     * 查询生产工单尺码列表
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 生产工单尺码
     */
    @Override
    public List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItemList(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem) {
        return proWorkOrderSoSizeItemMapper.selectProWorkOrderSoSizeItemList(proWorkOrderSoSizeItem);
    }

    @Override
    public ProWorkOrderSoSizeItemDynamic selectProWorkOrderSoSizeItemListDynamic(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem) {
        List<ProWorkOrderSoSizeItem> list = proWorkOrderSoSizeItemMapper.selectProWorkOrderSoSizeItemList(proWorkOrderSoSizeItem);
        ProWorkOrderSoSizeItemDynamic rst = new ProWorkOrderSoSizeItemDynamic();
        rst.setSizeList(list);
        LinkedHashMap<String, String> tempColumns = new LinkedHashMap<String, String>();
        tempColumns.put("standardSizeType", ProWorkOrderSoSizeItemDynamic.ALL_COLUMN.get("standardSizeType"));
        tempColumns.put("quantity", ProWorkOrderSoSizeItemDynamic.ALL_COLUMN.get("quantity"));
        tempColumns.put("lossNum", ProWorkOrderSoSizeItemDynamic.ALL_COLUMN.get("lossNum"));
        tempColumns.put("quantityQualify", "已包装数量");
        tempColumns.put("reportQuantity", "本次包装数量");
        //动态字段
        list.forEach(s -> {
            Map<String, Object> sdata = BeanUtil.beanToMap(s);
            ProWorkOrderSoSizeItemDynamic.ALL_COLUMN.forEach((k, v) -> {
                if (!tempColumns.containsKey(k) && sdata.get(k) != null
                        && !"".equals(sdata.get(k))) {
                    tempColumns.put(k, v);
                }
            });
        });
        rst.setColumns(tempColumns);
        return rst;
    }

    @Override
    public List<Map<String, Object>> selectProWorkOrderSoSizeItemListMap(QueryWrapper<ProWorkOrderSoSizeItem> query) {
        return proWorkOrderSoSizeItemMapper.selectProWorkOrderSoSizeItemListMap(query);
    }

    @Override
    public List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItem(QueryWrapper<ProWorkOrderSoSizeItem> query) {
        return proWorkOrderSoSizeItemMapper.selectListByQw(query);
    }

    /**
     * 新增生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    @Override
    public int insertProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem) {
        proWorkOrderSoSizeItem.createAction();
        return proWorkOrderSoSizeItemMapper.insertProWorkOrderSoSizeItem(proWorkOrderSoSizeItem);
    }

    /**
     * 修改生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    @Override
    public int updateProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem) {
        return proWorkOrderSoSizeItemMapper.updateProWorkOrderSoSizeItem(proWorkOrderSoSizeItem);
    }

    /**
     * 批量删除生产工单尺码
     *
     * @param workorderSoSizeItemIds 需要删除的生产工单尺码主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemIds(Long[] workorderSoSizeItemIds) {
        return proWorkOrderSoSizeItemMapper.deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemIds(workorderSoSizeItemIds);
    }

    /**
     * 删除生产工单尺码信息
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId) {
        return proWorkOrderSoSizeItemMapper.deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemId(workorderSoSizeItemId);
    }

    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        QueryWrapper<ProWorkOrderSoSizeItem> proWorkOrderSoSizeItemQueryWrapper = new QueryWrapper<>();
        proWorkOrderSoSizeItemQueryWrapper.eq("workorder_code", workorderCode);
        proWorkOrderSoSizeItemMapper.deleteProWorkOrderSoSizeItem(proWorkOrderSoSizeItemQueryWrapper);
    }
}
