package com.ximai.mes.pro.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.ProWorkorderBomm;
import com.ximai.mes.pro.mapper.ProWorkorderBomMapper;
import com.ximai.mes.pro.service.IProWorkorderBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 生产工单BOM组成Service业务层处理
 *
 * @date 2022-05-09
 */
@Service
public class ProWorkorderBomServiceImpl implements IProWorkorderBomService {

    @Autowired
    private ProWorkorderBomMapper proWorkorderBomMapper;

    /**
     * 查询生产工单BOM组成
     *
     * @param lineId 生产工单BOM组成主键
     * @return 生产工单BOM组成
     */
    @Override
    public ProWorkorderBomm selectProWorkorderBomByLineId(Long lineId) {
        return proWorkorderBomMapper.selectProWorkorderBomByLineId(lineId);
    }

    /**
     * 查询生产工单BOM组成列表
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 生产工单BOM组成
     */
    @Override
    public List<ProWorkorderBomm> selectProWorkorderBomList(ProWorkorderBomm proWorkorderBomm) {
        return proWorkorderBomMapper.selectProWorkorderBomList(proWorkorderBomm);
    }

    /**
     * 新增生产工单BOM组成
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 结果
     */
    @Override
    public int insertProWorkorderBom(ProWorkorderBomm proWorkorderBomm) {
        proWorkorderBomm.createAction();
        return proWorkorderBomMapper.insertProWorkorderBom(proWorkorderBomm);
    }

    /**
     * 修改生产工单BOM组成
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 结果
     */
    @Override
    public int updateProWorkorderBom(ProWorkorderBomm proWorkorderBomm) {
        proWorkorderBomm.setUpdateTime(DateUtils.getNowDate());
        return proWorkorderBomMapper.updateProWorkorderBom(proWorkorderBomm);
    }

    /**
     * 批量删除生产工单BOM组成
     *
     * @param lineIds 需要删除的生产工单BOM组成主键
     * @return 结果
     */
    @Override
    public int deleteProWorkorderBomByLineIds(Long[] lineIds) {
        return proWorkorderBomMapper.deleteProWorkorderBomByLineIds(lineIds);
    }

    /**
     * 删除生产工单BOM组成信息
     *
     * @param lineId 生产工单BOM组成主键
     * @return 结果
     */
    @Override
    public int deleteProWorkorderBomByLineId(Long lineId) {
        return proWorkorderBomMapper.deleteProWorkorderBomByLineId(lineId);
    }

    @Override
    public int deleteProWorkorderBomByWorkorderId(Long workorderId) {
        return proWorkorderBomMapper.deleteProWorkorderBomByWorkorderId(workorderId);
    }

}
