package com.ximai.mes.pro.service;

import com.ximai.mes.pro.domain.ProPauseWork;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.qc.domain.QcAbnormalReport;

import java.util.List;


/**
 * 暂停作业记录表Service接口
 *
 * @author generator
 * @date 2024-03-12
 */
public interface IProPauseWorkService {
    /**
     * 查询暂停作业记录表
     *
     * @param pauseWorkId 暂停作业记录表主键
     * @return 暂停作业记录表
     */
    ProPauseWork selectProPauseWorkByPauseWorkId(Long pauseWorkId);

    /**
     * 查询暂停作业记录表列表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 暂停作业记录表集合
     */
    List<ProPauseWork> selectProPauseWorkList(ProPauseWork proPauseWork);

    /**
     * 新增暂停作业记录表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 结果
     */
    int insertProPauseWork(ProPauseWork proPauseWork);

    /**
     * 修改暂停作业记录表
     *
     * @param proPauseWork 暂停作业记录表
     * @return 结果
     */
    int updateProPauseWork(ProPauseWork proPauseWork);

    /**
     * 批量删除暂停作业记录表
     *
     * @param pauseWorkIds 需要删除的暂停作业记录表主键集合
     * @return 结果
     */
    int deleteProPauseWorkByPauseWorkIds(Long[] pauseWorkIds);

    /**
     * 删除暂停作业记录表信息
     *
     * @param pauseWorkId 暂停作业记录表主键
     * @return 结果
     */
    int deleteProPauseWorkByPauseWorkId(Long pauseWorkId);

    void insertObj(ProTask proTask);

    void insertProPauseWorks(ProTask proTask);

    void insertProTaskWorkunitAbnormal(QcAbnormalReport qcAbnormalReport);
}
