package com.ximai.mes.pro.schedule.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRule;
import com.ximai.mes.pro.domain.ProScheduleSetupRuleVal;
import com.ximai.mes.pro.schedule.AlgorithmDataContext;
import com.ximai.mes.pro.schedule.AlgorithmExtendDataSource;
import com.ximai.mes.pro.schedule.Equipment;
import com.ximai.mes.pro.schedule.Task;
import com.ximai.mes.pro.service.IProScheduleSetupRuleService;
import com.ximai.mes.pro.service.IProScheduleSetupRuleValService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 2.
 * 加载工单换型规则、换型规则属性值
 * 属性值包括待排任务
 * 设备已排最新任务
 */
@Component
public class ScheduleSetupRuleAlgorithmData implements AlgorithmExtendDataSource {

    @Autowired
    IProScheduleSetupRuleService proScheduleSetupRuleService;
    @Autowired
    IProScheduleSetupRuleValService proScheduleSetupRuleValService;

    @Override
    public void extendData(AlgorithmDataContext algorithmDataContext) {
        QueryWrapper<ProScheduleSetupRule> ruleQuery = new QueryWrapper<ProScheduleSetupRule>();
        Map<String, Map<String, Integer>> ruleMapOriginal = proScheduleSetupRuleService.selectProScheduleSetupRuleWithMap(ruleQuery);
        Map<String, Map<String, Integer>> ruleMap = new HashMap<String, Map<String, Integer>>();
        //转换为工单ID+工序换型规则配置
        algorithmDataContext.getJobs().forEach(job->{
            job.getJobExtend().getWorkorderList().forEach(workorder->{
                job.getTasks().forEach(task->{
                    Map<String, Integer> ruleData = ruleMapOriginal.get(workorder.getItemTypeName()+task.getProcessName());
                    if(ruleData!=null){
                        ruleMap.put(workorder.getWorkorderId()+task.getProcessName(),ruleData);
                    }
                });
            });
        });
        //加载待排任务属性规则值
        QueryWrapper<ProScheduleSetupRuleVal> setupRuleValQuery = new QueryWrapper<ProScheduleSetupRuleVal>();
        setupRuleValQuery.in("workorder_id", algorithmDataContext.getWorkorderIds());
        Map<String, Map<String, Object>> ruleValMap = proScheduleSetupRuleValService.selectScheduleSetupRuleValGroup(setupRuleValQuery);
        algorithmDataContext.getJobs().forEach(job->{
            job.getJobExtend().setSetupRuleMap(ruleMap);
            job.getJobExtend().setSetupRuleValsCur(ruleValMap);
        });
        //加载设备已排任务最新换型规则值
        List<Long> orderIds = new ArrayList<Long>();
        algorithmDataContext.getResources().forEach(s->{
            if(s instanceof Equipment){
                Equipment equipment = (Equipment)s;
                if(!equipment.getScheduleTask().isEmpty()){
                    Task task = equipment.getScheduleTask().get(0);
                    task.getJob().getJobExtend().getWorkorderList().forEach(workorder->{
                        orderIds.add(workorder.getWorkorderId());
                        Map<String, Integer> ruleData = ruleMapOriginal.get(workorder.getItemTypeName()+task.getProcessName());
                        if(ruleData!=null){
                            ruleMap.put(workorder.getWorkorderId()+task.getProcessName(), ruleData);
                        }
                    });
                }
            }
        });
        if(orderIds.isEmpty()){
            return;
        }
        setupRuleValQuery.clear();
        setupRuleValQuery.in("workorder_id", orderIds);
        Map<String, Map<String, Object>> newRuleValMap = proScheduleSetupRuleValService.selectScheduleSetupRuleValGroup(setupRuleValQuery);
        algorithmDataContext.getResources().forEach(s->{
            if(s instanceof Equipment){
                Equipment equipment = (Equipment)s;
                if(!equipment.getScheduleTask().isEmpty()){
                    Task task = equipment.getScheduleTask().get(0);
                    task.getJob().getJobExtend().setSetupRuleMap(ruleMap);
                    task.getJob().getJobExtend().setSetupRuleValsCur(newRuleValMap);
                }
            }
        });
    }

}
