package com.ximai.mes.pro.domain.sap;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class SAPDtoFeedback {
    // 生产订单号	AUFNR
    //部分/最后确认	AUERU
    //工序	VORNR
    //工作中心	ARBPL
    //产出物料数量	GMNGA
    //确认废品数量	XMNGA
    //返工数量	MNGA
    //计量单位	MEINH
    //差异原因	GRUND
    //机器工时	ISM01
    //机器工时单位`	ILE01
    //人工工时	ISM02
    //机器工时单位`	ILE02
    //确认文本	LTXA1
    //开始执行日期	ISDD
    //开始执行时间	ISDZ
    //完成执行日期	IEDD
    //完成执行时间	IEDZ
    //休息时间	ISERH
    //休息时间单位	ZEIER
    //记账日期	BUDAT

    private static final long serialVersionUID = 1L;
    @JSONField(name = "AUFNR", ordinal = 1)
    private String workorderCode;
    @JSONField(name = "AUERU", ordinal = 2)
    private String confirm;
    @JSONField(name = "VORNR", ordinal = 3)
    private String processOrder;
    @JSONField(name = "ARBPL", ordinal = 4)
    private String workstationCode;
    @JSONField(name = "GMNGA", ordinal = 5)
    private Integer feedbackQuantity;
    @JSONField(name = "XMNGA", ordinal = 6)
    private Integer feedbackScrapQuantity;
    @JSONField(name = "MNGA", ordinal = 7)
    private Integer feedbackReworkQuantity;

    @JSONField(name = "MEINH", ordinal = 8)
    private String unit;

    //  0001	机器故障
    //  0002	操作错误
    //  0003	有缺陷物料
    @JSONField(name = "GRUND", ordinal = 9)
    private String diffReason;

    @JSONField(name = "ISM01", ordinal = 10)
    private String machineTime;
    @JSONField(name = "ILE01", ordinal = 11)
    private String machineTimeUnit;

    @JSONField(name = "ILE02", ordinal = 12)
    private String personTimeUnit;
    @JSONField(name = "ISM02", ordinal = 13)
    private String personTime;
    @JSONField(name = "LTXA1", ordinal = 14)
    private String confirmText;
    // 计划开始时间
    @JSONField(name = "ISDD", ordinal = 15)
    private String execDay;
    // 执行时间
    @JSONField(name = "ISDZ", ordinal = 17)
    private String execSecond;
    // 计划结束时间
    @JSONField(name = "IEDD", ordinal = 16)
    private String execEndDay;
    // 执行结束时间
    @JSONField(name = "IEDZ", ordinal = 18)
    private String execEndSecond;

    @JSONField(name = "ISERH", ordinal = 19)
    private String breakTime;

    @JSONField(name = "ZEIER", ordinal = 20)
    private String breakTimeUnit;

    @JSONField(name = "BUDAT", ordinal = 21)
    private String dateBilling;

    @JSONField(name = "ITEM", ordinal = 22)
    private List<Item> items;


    @JSONField(name = "RUECK", ordinal = 23)
    private String cancelCode;
    @JSONField(name = "RMZHL", ordinal = 24)
    private String cancelItemCode;

    @AllArgsConstructor
    @Data
    public static class Item {
        // MATNR		1	物料编号
        // CHARG		1	批次编号
        // ERFMG		1	以录入项单位表示的数量
        @JSONField(name = "MATNR", ordinal = 1)
        private String itemCode;

        @JSONField(name = "CHARG", ordinal = 2)
        private String batchNo;

        @JSONField(name = "ERFMG", ordinal = 3)
        private BigDecimal quantity;
    }

}