package com.ximai.mes.od.service;

import com.ximai.mes.od.domain.OdSalesOrderDetail;

import java.util.List;

/**
 * 销售订单详情Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IOdSalesOrderDetailService {
    /**
     * 查询销售订单详情
     *
     * @param id 销售订单详情主键
     * @return 销售订单详情
     */
    OdSalesOrderDetail selectOdSalesOrderDetailById(String id);

    /**
     * 查询销售订单详情列表
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 销售订单详情集合
     */
    List<OdSalesOrderDetail> selectOdSalesOrderDetailList(OdSalesOrderDetail odSalesOrderDetail);

    /**
     * 新增销售订单详情
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 结果
     */
    int insertOdSalesOrderDetail(OdSalesOrderDetail odSalesOrderDetail);

    /**
     * 修改销售订单详情
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 结果
     */
    int updateOdSalesOrderDetail(OdSalesOrderDetail odSalesOrderDetail);

    /**
     * 批量删除销售订单详情
     *
     * @param ids 需要删除的销售订单详情主键集合
     * @return 结果
     */
    int deleteOdSalesOrderDetailByIds(String[] ids);

    /**
     * 删除销售订单详情信息
     *
     * @param id 销售订单详情主键
     * @return 结果
     */
    int deleteOdSalesOrderDetailById(String id);
}
