package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.vo.MdSaleUnitVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleUnitMapper;
import com.ximai.mes.md.domain.MdSaleUnit;
import com.ximai.mes.md.service.IMdSaleUnitService;

/**
 * 销售单位转换Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleUnitServiceImpl implements IMdSaleUnitService
{
    @Autowired
    private MdSaleUnitMapper mdSaleUnitMapper;

    /**
     * 查询销售单位转换
     *
     * @param id 销售单位转换主键
     * @return 销售单位转换
     */
    @Override
    public MdSaleUnitVo selectMdSaleUnitById(Long id)
    {
        return mdSaleUnitMapper.selectMdSaleUnitById(id);
    }

    /**
     * 查询销售单位转换列表
     *
     * @param mdSaleUnit 销售单位转换
     * @return 销售单位转换
     */
    @Override
    public List<MdSaleUnitVo> selectMdSaleUnitList(MdSaleUnit mdSaleUnit)
    {
        return mdSaleUnitMapper.selectMdSaleUnitList(mdSaleUnit);
    }

    /**
     * 新增销售单位转换
     *
     * @param mdSaleUnit 销售单位转换
     * @return 结果
     */
    @Override
    public int insertMdSaleUnit(MdSaleUnit mdSaleUnit)
    {
        mdSaleUnit.setCreateTime(DateUtils.getNowDate());
        return mdSaleUnitMapper.insertMdSaleUnit(mdSaleUnit);
    }

    /**
     * 修改销售单位转换
     *
     * @param mdSaleUnit 销售单位转换
     * @return 结果
     */
    @Override
    public int updateMdSaleUnit(MdSaleUnit mdSaleUnit)
    {
        mdSaleUnit.setUpdateTime(DateUtils.getNowDate());
        return mdSaleUnitMapper.updateMdSaleUnit(mdSaleUnit);
    }

    /**
     * 批量删除销售单位转换
     *
     * @param ids 需要删除的销售单位转换主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleUnitByIds(Long[] ids)
    {
        return mdSaleUnitMapper.deleteMdSaleUnitByIds(ids);
    }

    /**
     * 删除销售单位转换信息
     *
     * @param id 销售单位转换主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleUnitById(Long id)
    {
        return mdSaleUnitMapper.deleteMdSaleUnitById(id);
    }
}
