package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductCustomer;

/**
 * 产品客户配置Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductCustomerService
{
    /**
     * 查询产品客户配置
     *
     * @param productCustomerId 产品客户配置主键
     * @return 产品客户配置
     */
    public MdProductCustomer selectMdProductCustomerByProductCustomerId(Long productCustomerId);

    /**
     * 查询产品客户配置列表
     *
     * @param mdProductCustomer 产品客户配置
     * @return 产品客户配置集合
     */
    public List<MdProductCustomer> selectMdProductCustomerList(MdProductCustomer mdProductCustomer);

    /**
     * 新增产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    public int insertMdProductCustomer(MdProductCustomer mdProductCustomer);

    /**
     * 修改产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    public int updateMdProductCustomer(MdProductCustomer mdProductCustomer);

    /**
     * 批量删除产品客户配置
     *
     * @param productCustomerIds 需要删除的产品客户配置主键集合
     * @return 结果
     */
    public int deleteMdProductCustomerByProductCustomerIds(Long[] productCustomerIds);

    /**
     * 删除产品客户配置信息
     *
     * @param productCustomerId 产品客户配置主键
     * @return 结果
     */
    public int deleteMdProductCustomerByProductCustomerId(Long productCustomerId);
}
