package com.ximai.mes.constant;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum WorkorderStatusEnum {

    /**
     * 待发布
     */
    PREPARE("PREPARE","待发布"),
    /**
     * 已发布
     */
    PUBLISHED("PUBLISHED","已发布"),
    /**
     * 已组合
     */
    COMBINED("COMBINED","已组合"),
    /**
     * 已编排
     */
    ORCHESTRATED("ORCHESTRATED","已编排"),
    /**
     * 已排产
     */
    SCHEDULED("SCHEDULED","已排产"),
    /**
     * 已完成
     */
    FINISHED("FINISHED","已完成"),
    /**
     * 已取消
     */
    CANCELED("CANCELED","已取消"),
    /**
     * 暂停
     */
    STOPPAGE("STOPPAGE","待发布"),
    /**
     * 锁定
     */
    LOCK("LOCK","锁定"),
    /**
     * 已下达
     */
    ISSUED("ISSUED","已下达"),
    /**
     * 关闭/取消
     */
    CLOSE("CLOSE","关闭"),
    CANCEL("CANCEL","取消"),
    /**
     * 生产中
     */
    PRODUCING("PRODUCING","生产中");

    /**
     * Lock type
     */
    private final String status;

    /**
     * 枚举名称
     */
    public String enumName;

    WorkorderStatusEnum(String status, String enumName) {
        this.status = status;
        this.enumName = enumName;
    }

    public String getEnumName() {
        return enumName;
    }
    /**
     * Constructor with field of type
     */
    private WorkorderStatusEnum(String status) {
        this.status = status;
    }

    public String getValue() {
        return status;
    }


    public static WorkorderStatusEnum get(String value) {
        for (WorkorderStatusEnum temp : WorkorderStatusEnum.values()) {
            if (temp.getValue().equals(value)) {
                return temp;
            }
        }
        return null;
    }
}
