package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum ProStartWorkStartTypeEnum {

    /**
     * 暂停
     */
    NORMAL_STOP(0, "正常停止"),
    EXCEPTION_STOP(1, "异常暂停");

    /**
     * Lock type
     */
    private final Integer type;

    private final String statusCn;

    ProStartWorkStartTypeEnum(Integer type, String statusCn) {
        this.type = type;
        this.statusCn = statusCn;
    }

    public Integer getType() {
        return type;
    }

    public String getStatusCn() {
        return statusCn;
    }

    public static ProStartWorkStartTypeEnum get(Integer type) {
        for (ProStartWorkStartTypeEnum temp : ProStartWorkStartTypeEnum.values()) {
            if (temp.getType().equals(type)) {
                return temp;
            }
        }
        return null;
    }


}
