package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.md.service.IMdWorkstationService;
import com.ximai.mes.md.vo.MdWorkstationVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * title:
 * author:ZHT
 * date:2024/3/16
 * description:
 */
@RestController
@RequestMapping(value = "/api/v1/workstation")
public class WorkstationRestController {

    @Autowired
    private IMdWorkstationService workstationService;

    @ApiOperation(value = "工作中心创建")
    @BasicAuth
    @RequestMapping(value = "/workstationCreate", method = RequestMethod.POST)
    public AjaxResult WorkstationCreate(@RequestBody String mdWorkstationJson) {

       try {
           MdWorkstationVo mdWorkstationVo = JSON.parseObject(mdWorkstationJson).toJavaObject(MdWorkstationVo.class);

           int i = workstationService.workstationCreate(mdWorkstationVo);

           if (i == 2) {
               return AjaxResult.success("修改成功");
           }
           if (i == 3) {
               return AjaxResult.success("关闭成功");
           }
       }catch (Exception e){
          return AjaxResult.error(e.getMessage());
       }

        return AjaxResult.success("新增成功");
    }
}
