package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.constant.Constants;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.SapAjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.pro.domain.sap.SAPQcIqc;
import com.ximai.mes.qc.domain.QcIqc;
import com.ximai.mes.qc.service.IQcIqcService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value = "/api/v1/iqc")
public class QcIqcRestController extends BaseController {

    @Autowired
    private IQcIqcService qcIqcService;

    /**
     * sap ep 工单同步逻辑
     *
     * @param orderVo
     * @return
     */
    @ApiOperation(value = "打样工单创建")
    @BasicAuth
    @RequestMapping(value = "/sapapi", method = RequestMethod.POST)
    public SapAjaxResult sapapi(@RequestBody String iqcJsonStr) {
        SAPQcIqc sapQcIqc = JSON.parseObject(iqcJsonStr).toJavaObject(SAPQcIqc.class);

        QcIqc qcIqc = sapQcIqc.deepCopyObj(QcIqc.class);
        try {
            switch (sapQcIqc.getActionType()) {
                case Constants.METHOD_INSERT_TYPE:
                    qcIqcService.insertObj(qcIqc);
                    break;
                case Constants.METHOD_UPDATE_TYPE:
                    qcIqcService.updateObj(qcIqc);
                    break;
                case Constants.METHOD_DELETE_TYPE:
                    qcIqcService.deleteQcIqcByIqcCode(qcIqc.getIqcCode());
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            return SapAjaxResult.error(e.getMessage());
        }
        return SapAjaxResult.success();
    }


}
