package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.FeedbackRequest;
import com.ximai.mes.report.response.FeedbackResponse;
import com.ximai.mes.report.service.FeedbackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

@Api("生产报工")
@RestController
@RequestMapping("/report/pro/feedback")
public class FeedbackController extends BaseController {

    @Autowired
    FeedbackService feedbackService;
    /**
     * 新增生产报工记录
     */
    @ApiOperation("生产报工记录:明细界面")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录", businessType = BusinessType.QUERY)
    @GetMapping("/getList")
    public TableDataInfo getList(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getList(feedbackRequest);
        return getDataTable(feedbackResponseList);
    }



    @ApiOperation("生产报工记录")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工单", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkOrder")
    public TableDataInfo getListByWorkOrder(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkOrder(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }

    @ApiOperation("生产报工记录:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public TableDataInfo getListByWorkshop(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkshop(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }

    @ApiOperation("生产报工记录:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public TableDataInfo getListByWorkstation(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkstation(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }


    @ApiOperation("生产报工记录:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public TableDataInfo getListByWorkunit(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkunit(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }





    @ApiOperation("生产报工记录:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public TableDataInfo getListByProcess(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByProcess(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }


    @ApiOperation("生产报工记录:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public TableDataInfo getListByUser(@RequestBody FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByUser(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityFeedback()).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }
}
