package com.ximai.mes.pro.service.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestBom;

/**
 * 量产申请BOMService接口
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public interface IProProductionRequestBomService
{
    /**
     * 查询量产申请BOM
     *
     * @param bomItemId 量产申请BOM主键
     * @return 量产申请BOM
     */
    public ProProductionRequestBom selectProProductionRequestBomByBomItemId(Long bomItemId);

    /**
     * 查询量产申请BOM列表
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 量产申请BOM集合
     */
    public List<ProProductionRequestBom> selectProProductionRequestBomList(ProProductionRequestBom proProductionRequestBom);

    /**
     * 新增量产申请BOM
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 结果
     */
    public int insertProProductionRequestBom(ProProductionRequestBom proProductionRequestBom);

    /**
     * 修改量产申请BOM
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 结果
     */
    public int updateProProductionRequestBom(ProProductionRequestBom proProductionRequestBom);

    /**
     * 批量删除量产申请BOM
     *
     * @param bomItemIds 需要删除的量产申请BOM主键集合
     * @return 结果
     */
    public int deleteProProductionRequestBomByBomItemIds(Long[] bomItemIds);

    /**
     * 删除量产申请BOM信息
     *
     * @param bomItemId 量产申请BOM主键
     * @return 结果
     */
    public int deleteProProductionRequestBomByBomItemId(Long bomItemId);
}
