package com.ximai.mes.pro.mapper.productionSolution;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBom;

import java.util.List;

/**
 * 生产版本BOMMapper接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface ProProductionSolutionBomMapper {
    /**
     * 查询生产版本BOM
     *
     * @param bomItemId 生产版本BOM主键
     * @return 生产版本BOM
     */
    public ProProductionSolutionBom selectProProductionSolutionBomByBomItemId(Long bomItemId);

    /**
     * 查询生产版本BOM列表
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 生产版本BOM集合
     */
    public List<ProProductionSolutionBom> selectProProductionSolutionBomList(ProProductionSolutionBom proProductionSolutionBom);

    /**
     * 新增生产版本BOM
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 结果
     */
    public int insertProProductionSolutionBom(ProProductionSolutionBom proProductionSolutionBom);

    /**
     * 修改生产版本BOM
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 结果
     */
    public int updateProProductionSolutionBom(ProProductionSolutionBom proProductionSolutionBom);

    /**
     * 删除生产版本BOM
     *
     * @param bomItemId 生产版本BOM主键
     * @return 结果
     */
    public int deleteProProductionSolutionBomByBomItemId(Long bomItemId);

    /**
     * 批量删除生产版本BOM
     *
     * @param bomItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionSolutionBomByBomItemIds(Long[] bomItemIds);

    List<ProProductionSolutionBom> selectProProductionSolutionBomByProductionSolutionId(Long productionSolutionId);

    List<ProProductionSolutionBom> selectProProductionSolutionBomByItemId(Long itemId);
}
