package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产工单工序物料Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface ProWorkOrderProcessItemMapper {
    /**
     * 根据打样申请单id查询所属所有工序物料
     *
     * @param workorderProcessId
     * @return
     */
    List<ProWorkOrderProcessItem> selectProWorkOrderProcessItemByWorkorderProcessId(Long workorderProcessId);

    /**
     * 查询生产工单工序物料
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 生产工单工序物料
     */
    ProWorkOrderProcessItem selectProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId);

    /**
     * 查询生产工单工序物料列表
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 生产工单工序物料集合
     */
    List<ProWorkOrderProcessItem> selectProWorkOrderProcessItemList(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 新增生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    int insertProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 修改生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    int updateProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem);

    /**
     * 删除生产工单工序物料
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 结果
     */
    int deleteProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId);

    /**
     * 批量删除生产工单工序物料
     *
     * @param workorderProcessItemIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessItemByWorkorderProcessItemIds(Long[] workorderProcessItemIds);


//    \n" +
//            "${ew.customSqlSegment}")
//    List<MdWorkunitVo> selectMdWorkunitJoinWorkstation(@Param("ew") QueryWrapper<MdWorkunitVo> query);

    @Select("select * from pro_workorder pw left join pro_work_order_process pwop on pw.workorder_id = pwop.workorder_id  left join pro_work_order_process_item pwopi on pwop.workorder_process_id = pwopi.workorder_process_id  ${ew.customSqlSegment}")
    List<ProWorkOrderProcessItem> selectBomItemListByQw(@Param("ew") QueryWrapper<ProWorkOrderProcessItem> query);

    @Select("select ptw.task_workunit_id, t1.task_id,t3.*,t3.quantity quantity\n" +
            "from pro_task t1\n" +
            "         inner join pro_task_workunit ptw on t1.task_id = ptw.task_id\n" +
            "         inner join (select arrange_code, workorder_code,workorder_process_item_id,workorder_process_id,process_code,process_id,x2.t_sap_item_code sap_item_code,x2.item_name item_name,x1.sap_item_code w_sap_item_code,is_backflush,x2.quantity\n" +
            "                     from pro_workorder x1\n" +
            "                     inner  join (select t2.workorder_id,t1.workorder_process_item_id,t1.workorder_process_id,mi.sap_item_code t_sap_item_code,t1.quantity,t3.process_code,t2.process_id,t1.is_backflush,mi.item_name\n" +
            "                                            from pro_work_order_process_item t1\n" +
            "                                                     inner join pro_work_order_process t2\n" +
            "                                                                on t1.workorder_process_id = t2.workorder_process_id\n" +
            "                                                    inner join md_item mi\n" +
            "                                                                on t1.item_id = mi.item_id\n" +
            "                                            inner join pro_process t3\n" +
            "                                                                on t3.process_id = t2.process_id) x2 on x1.workorder_id = x2.workorder_id\n" +
            "                       and arrange_code is not null\n" +
            "                       and arrange_code != '') t3 on t1.arrange_code = t3.arrange_code  and  t1.process_id = t3.process_id  " +
            " ${ew.customSqlSegment}")
    List<ProWorkOrderProcessItem> selectProcessItemByQw(@Param("ew") QueryWrapper<ProWorkOrderProcessItem> query);


    @Delete("delete from pro_work_order_process_item where workorder_process_id in (select workorder_process_id from pro_work_order_process where workorder_code=#{workorderCode}) ")
    void deleteByWorkorderCode(@Param("workorderCode") String workorderCode);

    @Delete("delete from pro_work_order_process_item where workorder_process_id in (${workorderProcessIds}) ")
    void deleteByWorkorderProcessIds(@Param("workorderProcessIds") String workorderProcessIds);


    @Select(value = "select it.*,ss.*from pro_work_order_process_item it \n" +
            "INNER JOIN  pro_work_order_process ss on it.workorder_process_id=ss.workorder_process_id ${ew.customSqlSegment}")
    ProWorkOrderProcessItem selectProWordorderAndProcess(@Param("ew") QueryWrapper<ProWorkOrderProcess> queryWrapper);

    @Select(value = "select it.*,ss.*from pro_work_order_process_item it \n" +
            "INNER JOIN  pro_work_order_process ss on it.workorder_process_id=ss.workorder_process_id ${ew.customSqlSegment}")
    List<ProWorkOrderProcessItem> selectProWordorderAndProcess2(@Param("ew") QueryWrapper<ProWorkOrderProcess> queryWrapper);
}
