package com.ximai.mes.pro.dto;

import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 产品序列号打印记录对象 pro_product_qrcode_record
 *
 * @author generator
 * @date 2024-08-31
 */
@Data
public class ProProductQrcodeRecordDto {
    private static final long serialVersionUID = 1L;

    /** ID */
    @ApiModelProperty("ID")
    @TableId
    private Long recordId;

    /** 产品ID */
    @ApiModelProperty("产品ID")
    private Long itemId;

    /** 产品编码 */
    @ApiModelProperty("产品编码")
    private String itemCode;

    /** 产品名称 */
    @ApiModelProperty("产品名称")
    private String itemName;

    /** 工单ID */
    @ApiModelProperty("工单ID")
    private Long workOrderId;

    /** 工单编号 */
    @ApiModelProperty("工单编号")
    private String workOrderNo;

    /** 打印次数 */
    @ApiModelProperty("打印次数")
    private Long printTime;

    /** 二维码 */
    @ApiModelProperty("二维码")
    private String qrcode;

    /** 客户编码 */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String clientName;

    /** 产品描述 */
    @ApiModelProperty("产品描述")
    private String itemDesc;

    /** 创建者 */
    @ApiModelProperty("创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /** 更新者 */
    @ApiModelProperty("更新者")
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    /**
     * 模板ID
     */
    private Long templateId;


    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板编码（ID）
     */
    private String templateCode;

    /**
     * 模板类型
     */
    private String templateType;

    private String specification;

    private String qrcodeSub;
}
