package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 排产换型对照信息对象 pro_schedule_setup_rule
 *
 * @author generator
 * @date 2024-04-01
 */
@Data
public class ProScheduleSetupRuleExcelExport extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @TableId
    private Long ruleId;

    /** 换型关键字 */
    @ApiModelProperty("换型关键字")
    @Excel(name = "换型关键字")
    private String ruleCode;

    /** 产品类别ID */
    @ApiModelProperty("产品类别ID")
    private Long itemTypeId;

    /** 产品类别名称 */
    @ApiModelProperty("产品类别名称")
    @Excel(name = "产品类别名称")
    private String itemTypeName;

    /** 工序ID */
    @ApiModelProperty("工序ID")
    private Long processId;

    /** 工序名称 */
    @ApiModelProperty("工序名称")
    @Excel(name = "工序名称")
    private String processName;

    /** 刀 */
    @ApiModelProperty("刀")
    @Excel(name = "刀")
    private Integer tool;

    /** 模 */
    @ApiModelProperty("模")
    @Excel(name = "模")
    private Integer mould;

    /** 版 */
    @ApiModelProperty("版")
    @Excel(name = "版")
    private Integer plate;

    /** 材料（反冲） */
    @ApiModelProperty("材料(反冲)")
    @Excel(name = "材料(反冲)")
    private Integer materialRecoil;

    /** 印张长度 */
    @ApiModelProperty("印张长度")
    @Excel(name = "印张长度")
    private Integer sheetLength;

    /** 印张宽度 */
    @ApiModelProperty("印张宽度")
    @Excel(name = "印张宽度")
    private Integer sheetWidth;

    /** 产品规格 */
    @ApiModelProperty("产品规格")
    @Excel(name = "产品规格")
    private Integer productStandard;

    /** 正反颜色 */
    @ApiModelProperty("正反颜色")
    @Excel(name = "正反颜色")
    private Integer proConColor;

    /**  */
    @ApiModelProperty("Inlay")
    @Excel(name = "Inlay")
    private Integer inlay;

    /** 工艺路线 */
    @ApiModelProperty("工艺路线")
    @Excel(name = "工艺路线")
    private Integer routeCode;

    /** 产品材质宽度 */
    @ApiModelProperty("产品材质宽度")
    @Excel(name = "产品材质宽度")
    private Integer productWidth;

}
