package com.ximai.mes.pro.domain.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingCreate;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/23
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionProcessVo extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * ID
     */
    private Long productionSolutionProcessId;

    /**
     * 生产版本ID
     */
    private Long productionSolutionId;

    /**
     * 记录ID
     */
    private Long recordId;

    /**
     * 工序id
     */
    private Long processId;

    /**
     * 工序编码
     */
    private String processCode;

    /**
     * 工作中心
     */
    private Long workstationId;

    /**
     * 工作中心名称
     */
    private String workstationName;


    /**
     * 关键工序
     */
    private String keyFlag;

    /**
     * 固化时间
     */
    private BigDecimal solidifyTime;

    /**
     * 是否检验
     */
    private String isCheck;

    /**
     * 序号
     */
    private String idx;

    @ApiModelProperty("是否外协")
    private String outsourced;

    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer serial;

    /**
     * 工作中心编码
     */
    private String workstationCode;

    /**
     * 加工方式
     */
    private String processingMethod;

    /**
     * 工序名称
     */
    private String processName;

    /**
     * 工序备注
     */
    private String processRemark;

    /**
     * 基本数量
     */
    private BigDecimal quantity;

    /**
     * 工序计量单位
     */
    private String unitOfMeasure;
    /**
     * 副單位
     */
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    private BigDecimal unitConvert;

    /**
     * 雇员数量
     */
    private int employeesNum;

    /**
     * 标准工时
     */
    private BigDecimal stdWorkingTime;

    /**
     * 换行时间
     */
    private BigDecimal lineBreakTime;

    /**
     * 工时单位
     */
    private String stdWorkingTimeUom;

    /**
     * 采购信息记录号
     */
    private String procurementInformationId;

    /**
     * 供应商科目编号
     */
    private String vendorSubjectId;

    /**
     * 采购信息记录中的净价
     */
    private BigDecimal netPrice;

    /**
     * 采购组织
     */
    private String procurementOrganization;

    /**
     * 备注
     */
    private String remark;


    /** 封切机开边 */
    @Excel(name = "封切机开边")
    private String sacmForEdgeOpening;

    /** 封切机粘贴复合 */
    @Excel(name = "封切机粘贴复合")
    private String sacmForPasteComposite;

    /** 封切机热复合 */
    @Excel(name = "封切机热复合")
    private String sacmForThermalComposite;

    /** 封切机贴标 */
    @Excel(name = "封切机贴标")
    private String sacmForLabeling;

    /** 封切机装扣 */
    @Excel(name = "封切机装扣")
    private String sacmForBuckleUp;

    /** 封切机压痕 */
    @Excel(name = "封切机压痕")
    private String sacmForCreasing;

    /** 封切机风琴 */
    @Excel(name = "封切机风琴")
    private String sacmForOrgan;

    /** 封切机热切 */
    @Excel(name = "封切机热切")
    private String sacmForThermalCutting;

    /** 封切机热自合 */
    @Excel(name = "封切机热自合")
    private String sacmForThermalSelfFusion;

    /** 封切机压齿 */
    @Excel(name = "封切机压齿")
    private String sacmForMolarTooth;

    /** 封切机分切 */
    @Excel(name = "封切机分切")
    private String sacmForSlitting;

    /**
     * 工序物料
     */
    @ApiModelProperty("工序物料")
    private List<ProProductionSolutionProcessItem> processItemList=new ArrayList<>();

    /**
     * 生产版本工序检验项
     **/
    @ApiModelProperty("工序检验项")
    private List<ProProductionSolutionProcessQcindexVo> qcindexList=new ArrayList<>();

    /**
     * 生产版本工序工装夹具
     **/
    @ApiModelProperty("工装夹具")
    private List<ProProductionSolutionProcessToolVo> toolList=new ArrayList<>();


    /**
     * 规格书
     */
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;


    /**
     * 工序流向id
     */
    private Long directionProcessId;

    /**
     * 工序流向编码
     */
    private String directionProcessCode;


    /**
     * 工序流向编码
     */
    private String directionProcessName;

    /**
     * 生产版本工序图纸
     **/
    @ApiModelProperty("图纸列表")
    private List<ProProductionSolutionProcessDrawing> drawingList=new ArrayList<>();


    public ProProductionSolutionProcess getProductionSolutionProcess(ProProductionSolutionProcessVo proProductionSolutionProcessVo) {
        ProProductionSolutionProcess proProductionSolutionProcess = new ProProductionSolutionProcess();
        BeanUtils.copyProperties(proProductionSolutionProcessVo, proProductionSolutionProcess);
        return proProductionSolutionProcess;
    }
}
