package com.ximai.mes.pro.domain.sap;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 工序任务外协关系对象 pro_task_assistprocess
 *
 * @author generator
 * @date 2024-03-29
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SAPTaskAssistProcess extends BaseEntity {
    private static final long serialVersionUID = 1L;

    private String actionType;

    @JSONField(name = "AUFNR")
    private String workorderCode;

    @JSONField(name = "ABLAD")
    private String childWorkorderCode;

    @JSONField(name = "BSART")
    private String workorderType;

    @JSONField(name = "WERKS")
    private String factoryName;

    // applicant
    @JSONField(name = "AFNAM")
    private String applicant;

    // 公司代码
    @JSONField(name = "BUKRS")
    private String companyCode;

    // 采购组织  purchasing organization
    @JSONField(name = "EKORG")
    private String purchaOrgani;


    // 采购组
    @JSONField(name = "EKGRP")
    private String purchaGroup;


    @JSONField(name = "WEMPF")
    private String processIdx;


    @JSONField(name = "TXZ01")
    private String processDesc;


    /**
     * 外协数量
     */
    @JSONField(name = "MENGE")
    private Long quantity;

    /**
     * 外协数量
     */
    @JSONField(name = "MEINS")
    private String unit;


    /**
     * 交回时间
     */
    @JSONField(name = "EEIND")

    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求到货日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date returnTime;


    @JSONField(name = "LIFNR")
    // 供应商 vendor
    private String vendor;


    //  价格 price
    @JSONField(name = "KBETR")
    private String price;


    //  定价基数 priceBase
    @JSONField(name = "KPEIN")
    private String priceBase;

    @JSONField(name = "KOEIN")
    private String priceType;


    // 税码 texCode
    @JSONField(name = "MWSKZ")
    private String texCode;


    // 物料组 物料组编码
    @JSONField(name = "MATKL")
    private String itemTypeCode;

    // 物料组 category
    @JSONField(name = "KNTTP")
    private String category;
}
