package com.ximai.mes.md.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.md.domain.MdWorkunitWorker;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 岗位资源Mapper接口
 *
 * @author generator
 * @date 2024-07-17
 */
public interface MdWorkunitWorkerMapper extends BaseMapper<MdWorkunitWorker> {
    /**
     * 查询岗位资源
     *
     * @param id 岗位资源主键
     * @return 岗位资源
     */
    MdWorkunitWorker selectMdWorkunitWorkerById(Long id);

    @Select(value = "select t1.*,t2.workunit_name from md_workunit_worker t1 inner join md_workunit t2 on t1.workunit_id = t2.workunit_id  ${ew.customSqlSegment}")
    List<MdWorkunitWorker> selectListByQw(@Param("ew") QueryWrapper<MdWorkunitWorker> query);

    /**
     * 查询岗位资源列表
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 岗位资源集合
     */
    List<MdWorkunitWorker> selectMdWorkunitWorkerList(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 新增岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    int insertMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 修改岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    int updateMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 删除岗位资源
     *
     * @param id 岗位资源主键
     * @return 结果
     */
    int deleteMdWorkunitWorkerById(Long id);

    /**
     * 批量删除岗位资源
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteMdWorkunitWorkerByIds(Long[] ids);

    MdWorkunitWorker getMdWorkunitWorkerByUserName(MdWorkunitWorker mdWorkunitWorker);
}
