package com.ximai.mes.md.domain;

import java.math.BigDecimal;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品外观对象 md_product_look
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MdProductLook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 长;单位cm */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /** 宽;单位cm */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /** 高;单位cm */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /** 厚度;单位mm */
    @Excel(name = "厚度;单位mm")
    private BigDecimal thick;

    /** 成品克重;单位g */
    @Excel(name = "成品克重;单位g")
    private BigDecimal weight;

    /** 角型 */
    @Excel(name = "角型")
    private String angleType;

    /**是否异型**/
    private String isAllotype;

    /**是否直角**/
    private String isRightAngle;

    /**圆角**/
    private String fillet;

    /** 角度(单位mm) */
    @Excel(name = "角度(单位mm)")
    private BigDecimal angle;

    /** 孔径(单位mm) */
    @Excel(name = "孔径(单位mm)")
    private BigDecimal aperture;

    /** 单层厚(单位丝) */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /** 单重(单位KG) */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /** 层数 */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /** 是否防霉(is_open) */
    @Excel(name = "是否防霉(is_open)")
    private String isMould;

    /** 是否写码(is_open) */
    @Excel(name = "是否写码(is_open)")
    private String isCoding;

    /** 体系认证(product_sys_certification) */
    @Excel(name = "体系认证(product_sys_certification)")
    private String certification;

    /** 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角； */
    @Excel(name = "样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；")
    private String shape;

    /** 样品形状大小（mm） */
    @Excel(name = "样品形状大小", readConverterExp = "m=m")
    private BigDecimal shapeSize;

    @Excel(name = "产品正面")
    private String frontImg;

    @Excel(name = "产品背面")
    private String  backImg;

    @Excel(name = "正面颜色")
    private String frontColorName;

    @Excel(name = "反面颜色")
    private String oppositeColorName;

    /**
     * 正面颜色
     */
    private String[] frontColor;

    /**
     * 反面颜色
     */
    private String[] oppositeColor;

    @Excel(name = "系数")
    private BigDecimal coefficient;


}
