package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdColor;
import com.ximai.mes.md.service.IMdColorService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 颜色主数据Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/md/color")
public class MdColorController extends BaseController
{
    @Autowired
    private IMdColorService mdColorService;

    /**
     * 查询颜色主数据列表
     */
    @PreAuthorize("@ss.hasPermi('md:color:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdColor mdColor)
    {
        startPage();
        List<MdColor> list = mdColorService.selectMdColorList(mdColor);
        return getDataTable(list);
    }

    /**
     * 获取颜色主数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:color:query')")
    @GetMapping(value = "/{colorId}")
    public AjaxResult getInfo(@PathVariable("colorId") Long colorId)
    {
        return AjaxResult.success(mdColorService.selectMdColorByColorId(colorId));
    }

    /**
     * 新增颜色主数据
     */
    @PreAuthorize("@ss.hasPermi('md:color:add')")
    @Log(title = "颜色主数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdColor mdColor)
    {
        return toAjax(mdColorService.insertMdColor(mdColor));
    }

    /**
     * 修改颜色主数据
     */
    @PreAuthorize("@ss.hasPermi('md:color:edit')")
    @Log(title = "颜色主数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdColor mdColor)
    {
        return toAjax(mdColorService.updateMdColor(mdColor));
    }

    /**
     * 删除颜色主数据
     */
    @PreAuthorize("@ss.hasPermi('md:color:remove')")
    @Log(title = "颜色主数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{colorIds}")
    public AjaxResult remove(@PathVariable Long[] colorIds)
    {
        return toAjax(mdColorService.deleteMdColorByColorIds(colorIds));
    }
}
