package com.ximai.mes.cal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.cal.domain.CalWorkunit;
import com.ximai.mes.cal.mapper.CalWorkunitMapper;
import com.ximai.mes.cal.service.ICalWorkunitService;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.md.service.IMdWorkunitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 计划工作单元Service业务层处理
 *
 * @author generator
 * @date 2024-03-14
 */
@Service
public class CalWorkunitServiceImpl implements ICalWorkunitService {

    @Resource
    private CalWorkunitMapper calWorkunitMapper;

    @Resource
    private MdWorkunitMapper mdWorkunitMapper;

    @Autowired
    private IMdWorkunitService mdWorkunitService;

    /**
     * 查询计划工作单元
     *
     * @param id 计划工作单元主键
     * @return 计划工作单元
     */
    @Override
    public CalWorkunit getObjById(Long id) {
        return calWorkunitMapper.selectCalWorkunitById(id);
    }

    /**
     * 查询计划工作单元列表
     *
     * @param calWorkunit 计划工作单元
     * @return 计划工作单元
     */
    @Override
    public List<CalWorkunit> selectCalWorkunitList(CalWorkunit calWorkunit) {
        return calWorkunitMapper.selectCalWorkunitList(calWorkunit);
    }

    /**
     * 新增计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    @Override
    public int insertCalWorkunit(CalWorkunit calWorkunit) {
        calWorkunit.createAction();
        return calWorkunitMapper.insertCalWorkunit(calWorkunit);
    }

    /**
     * 修改计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    @Override
    public int updateCalWorkunit(CalWorkunit calWorkunit) {
        calWorkunit.updateAction();
        return calWorkunitMapper.updateCalWorkunit(calWorkunit);
    }

    /**
     * 批量删除计划工作单元
     *
     * @param ids 需要删除的计划工作单元主键
     * @return 结果
     */
    @Override
    public int deleteCalWorkunitByIds(Long[] ids) {
        return calWorkunitMapper.deleteCalWorkunitByIds(ids);
    }

    /**
     * 删除计划工作单元信息
     *
     * @param id 计划工作单元主键
     * @return 结果
     */
    @Override
    public int deleteCalWorkunitById(Long id) {
        return calWorkunitMapper.deleteCalWorkunitById(id);
    }

    @Override
    public void deleteCalWorkunitByPlanCode(String planCode) {
        calWorkunitMapper.deleteCalWorkunitByPlanCode(planCode);
    }

    @Override
    public List<Object> treeMenu() {
        QueryWrapper<CalWorkunit> objectQueryWrapper = new QueryWrapper<>();
        List<CalWorkunit> calWorkunits = calWorkunitMapper.selectListByQw(objectQueryWrapper);

        Map<String, List<CalWorkunit>> factoryGroupMap = calWorkunits.stream().collect(Collectors.groupingBy(CalWorkunit::getFactoryId));

        List<Object> factoryList = new ArrayList<>();
        for (Map.Entry<String, List<CalWorkunit>> fEntry : factoryGroupMap.entrySet()) {
            List<CalWorkunit> list = fEntry.getValue();
            List<Object> workshopChildList = new ArrayList<>();
            Map<String, List<CalWorkunit>> wsGroupMap = list.stream().collect(Collectors.groupingBy(CalWorkunit::getWorkshopId));
            for (Map.Entry<String, List<CalWorkunit>> wEntry : wsGroupMap.entrySet()) {
                list = wEntry.getValue();
                List<Object> workstationChildList = new ArrayList<>();
                Map<String, List<CalWorkunit>> wstaGroupMap = list.stream().collect(Collectors.groupingBy(CalWorkunit::getWorkstationId));
                for (Map.Entry<String, List<CalWorkunit>> wsEntry : wstaGroupMap.entrySet()) {
                    list = wsEntry.getValue();
                    Set<String> sets = new HashSet<>();
                    List<Map<String, Object>> workunitList = list.stream().map(x -> {
                        Map<String, Object> hashMap = new HashMap<>();
                        boolean add = sets.add(DataUtil.getNormalData(x.getWorkunitId(), ""));
                        if (add) {
                            hashMap.put("id", x.getWorkunitId());
                            hashMap.put("label", x.getWorkunitName());
                            hashMap.put("level", 4);
                            return hashMap;
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    Map<String, Object> workstationMap = new HashMap<>();
                    workstationMap.put("children", workunitList);
                    workstationMap.put("label", list.get(0).getWorkstationName());
                    workstationMap.put("id", wsEntry.getKey());
                    workstationMap.put("level", 3);
                    workstationChildList.add(workstationMap);
                }
                HashMap<Object, Object> workshopMap = new HashMap<>();
                workshopMap.put("children", workstationChildList);
                workshopMap.put("label", list.get(0).getWorkshopName());
                workshopMap.put("id", wEntry.getKey());
                workshopMap.put("level", 2);

                workshopChildList.add(workshopMap);
            }
            Map<String, Object> factoryMap = new HashMap<>();
            factoryMap.put("children", workshopChildList);
            factoryMap.put("label", list.get(0).getFactoryName());
            factoryMap.put("id", fEntry.getKey());
            factoryMap.put("level", 1);
            factoryList.add(factoryMap);

        }
        return factoryList;
    }

    @Override
    public List<MdWorkunit> selectUnSelectList(CalWorkunit calWorkunit) {
        Long planId = calWorkunit.getPlanId();
        String workunitCode = calWorkunit.getWorkunitCode();
        String workunitName = calWorkunit.getWorkunitName();
        String workstationName = calWorkunit.getWorkstationName();
        String workshopName = calWorkunit.getWorkshopName();


        QueryWrapper<CalWorkunit> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotEmpty(planId), "t1.plan_id", planId);
        queryWrapper.eq(StringUtils.isNotEmpty(workunitCode), "t2.workunit_code", workunitCode);
        queryWrapper.like(StringUtils.isNotEmpty(workunitName), "t2.workunit_name", workunitName);
        queryWrapper.like(StringUtils.isNotEmpty(workstationName), "t3.workstation_name", workstationName);
        queryWrapper.like(StringUtils.isNotEmpty(workshopName), "t4.workshop_name", workshopName);
        queryWrapper.isNotNull("t2.workunit_name");
        List<MdWorkunit> calWorkunits = calWorkunitMapper.selectListByQwV2(queryWrapper);
        return calWorkunits;
    }


    @Override
    public List<MdWorkunit> getWorkunitByPlanId(CalWorkunit calWorkunit,List<CalWorkunit> calWorkunits) {
        String workunitCode = calWorkunit.getWorkunitCode();
        String workunitName = calWorkunit.getWorkunitName();
        String workstationName = calWorkunit.getWorkstationName();
        String workshopName = calWorkunit.getWorkshopName();
        List<String> workunitCodes = calWorkunits.stream().map(calWorkunit1 -> calWorkunit1.getWorkunitCode()).collect(Collectors.toList());
        List<MdWorkunit> mdWorkunits = calWorkunitMapper.selectMdworkunitList(workunitCode,workunitName,workstationName,workshopName,workunitCodes.size() > 0 ? workunitCodes : null);
        return mdWorkunits;
    }

}
