package com.ximai.mes.cal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.mapper.CalPlanMapper;
import com.ximai.mes.cal.mapper.CalPlanWorkunitMapper;
import com.ximai.mes.cal.mapper.CalShiftMapper;
import com.ximai.mes.cal.mapper.CalWorkunitMapper;
import com.ximai.mes.cal.service.ICalPlanWorkunitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 计划工作单元Service业务层处理
 *
 * @author generator
 * @date 2024-03-14
 */
@Service
public class CalPlanWorkunitServiceImpl implements ICalPlanWorkunitService {

    @Autowired
    private CalPlanWorkunitMapper calPlanWorkunitMapper;

    @Autowired
    private CalPlanMapper calPlanMapper;

    @Autowired
    private CalWorkunitMapper calWorkunitMapper;

    @Autowired
    private CalShiftMapper calShiftMapper;


    /**
     * 查询计划工作单元
     *
     * @param planWorkunitId 计划工作单元主键
     * @return 计划工作单元
     */
    @Override
    public CalPlanWorkunit selectCalPlanWorkunitByPlanWorkunitId(Long planWorkunitId) {
        return calPlanWorkunitMapper.selectCalPlanWorkunitList(new CalPlanWorkunit(planWorkunitId)).get(0);
    }

    /**
     * 查询计划工作单元列表
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 计划工作单元
     */
    @Override
    public List<CalPlanWorkunit> selectCalPlanWorkunitList(CalPlanWorkunit calPlanWorkunit) {
        return calPlanWorkunitMapper.selectCalPlanWorkunitList(calPlanWorkunit);
    }


    @Override
    public List<CalPlanWorkunit> selectListByQw(QueryWrapper<CalPlanWorkunit> query) {
        return calPlanWorkunitMapper.selectListByQw(query);
    }

    @Override
    public List<CalPlanWorkunit> selectListWithSchedule(QueryWrapper<CalPlanWorkunit> query) {
        return calPlanWorkunitMapper.selectListWithSchedule(query);
    }

    /**
     * 新增计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    @Override
    public int insertCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit) {
        calPlanWorkunit.createAction();
        return calPlanWorkunitMapper.insertCalPlanWorkunit(calPlanWorkunit);
    }

    /**
     * 修改计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    @Override
    public int updateCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit) {
        calPlanWorkunit.updateAction();
        return calPlanWorkunitMapper.updateCalPlanWorkunitWorkStatus(calPlanWorkunit);
    }

    /**
     * 修改计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    @Override
    public int updateCalPlanWorkunitWorkStatus(CalPlanWorkunit calPlanWorkunit) {
        calPlanWorkunit.updateAction();
        return calPlanWorkunitMapper.updateCalPlanWorkunitWorkStatus(calPlanWorkunit);
    }


    /**
     * 批量删除计划工作单元
     *
     * @param planWorkunitIds 需要删除的计划工作单元主键
     * @return 结果
     */
    @Override
    public int deleteListByIds(Long[] planWorkunitIds) {
        return calPlanWorkunitMapper.deleteCalPlanWorkunitByids(planWorkunitIds);
    }

    /**
     * 删除计划工作单元信息
     *
     * @param planWorkunitId 计划工作单元主键
     * @return 结果
     */
    @Override
    public int deleteCalPlanWorkunitByPlanWorkunitId(Long planWorkunitId) {
        return calPlanWorkunitMapper.deleteCalPlanWorkunitByid(planWorkunitId);
    }

    @Override
    public int delete(QueryWrapper<CalPlanWorkunit> eq) {
        return calPlanWorkunitMapper.delete(eq);
    }
}
