package com.ximai.mes.cal.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.domain.CalTeamMember;
import com.ximai.mes.cal.domain.CalTeamshift;
import com.ximai.mes.cal.domain.vo.CalCalendar;
import com.ximai.mes.cal.domain.vo.CalShiftVo;
import com.ximai.mes.cal.mapper.CalPlanWorkunitMapper;
import com.ximai.mes.cal.mapper.CalShiftMapper;
import com.ximai.mes.cal.mapper.CalTeamMemberMapper;
import com.ximai.mes.cal.mapper.CalTeamshiftMapper;
import com.ximai.mes.cal.service.ICalCalendarService;
import com.ximai.mes.cal.utils.MesCalendarUtil;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class CalCalendarServiceImpl implements ICalCalendarService {


    @Autowired
    private CalTeamshiftMapper calTeamshiftMapper;

    @Autowired
    private CalTeamMemberMapper calTeamMemberMapper;

    @Autowired
    private MdWorkunitMapper mdWorkunitMapper;


    @Autowired
    private CalPlanWorkunitMapper calPlanWorkunitMapper;
    @Resource
    private CalShiftMapper calShiftMapper;

    /**
     * 1.循环生成当前月份每一天的CalCalendar
     * 2.根据月份和班组类型查询合适的plan
     * 3.根据plan上的Shift_type和shift_method计算每个班组的班次
     * 4.设置CalShiftTeamBean
     *
     * @param day
     * @param calenderType
     * @return
     */
    @Override
    public List<CalCalendar> getCalendarByType(Date day, String calenderType) {
        List<CalCalendar> calendars = null;
        calendars = MesCalendarUtil.getDays(day);
        for (CalCalendar cal : calendars) {
            CalTeamshift param2 = new CalTeamshift();
            param2.setTheDay(cal.getTheDay());
            param2.setCalendarType(calenderType);
            List<CalTeamshift> teamshifts = calTeamshiftMapper.selectCalTeamshiftList(param2);
            cal.setTeamShifts(teamshifts);
            if (CollUtil.isNotEmpty(teamshifts)) {
                cal.setShiftType(teamshifts.get(0).getShiftType());
            }
        }
        return calendars;
    }

    @Override
    public List<CalCalendar> getCalendarByTeam(Date day, Long teamId) {
        List<CalCalendar> calendars = null;
        calendars = MesCalendarUtil.getDays(day);
        for (CalCalendar cal : calendars) {
            CalTeamshift param2 = new CalTeamshift();
            param2.setTheDay(cal.getTheDay());
            param2.setTeamId(teamId);
            List<CalTeamshift> teamshifts = calTeamshiftMapper.selectCalTeamshiftList(param2);
            cal.setTeamShifts(teamshifts);
            if (CollUtil.isNotEmpty(teamshifts)) {
                cal.setShiftType(teamshifts.get(0).getShiftType());
            }
        }
        return calendars;
    }

    @Override
    public List<CalCalendar> getCalendarByUser(Date day, Long userId) {
        List<CalCalendar> calendars = null;
        CalTeamMember param = new CalTeamMember();
        param.setUserId(userId);
        List<CalTeamMember> members = calTeamMemberMapper.selectCalTeamMemberList(param);
        if (CollUtil.isNotEmpty(members)) {
            Long teamId = members.get(0).getTeamId();
            calendars = MesCalendarUtil.getDays(day);
            for (CalCalendar cal : calendars) {
                CalTeamshift param2 = new CalTeamshift();
                param2.setTheDay(cal.getTheDay());
                param2.setTeamId(teamId);
                List<CalTeamshift> teamshifts = calTeamshiftMapper.selectCalTeamshiftList(param2);
                cal.setTeamShifts(teamshifts);
                if (CollUtil.isNotEmpty(teamshifts)) {
                    cal.setShiftType(teamshifts.get(0).getShiftType());
                }
            }
        }

        return calendars;
    }


    @Override
    public List<CalCalendar> getCalWorkunits(Date day, CalCalendar calCalendar) {
        List<CalCalendar> calendars = MesCalendarUtil.getDays(day);
        for (CalCalendar cal : calendars) {
            QueryWrapper<CalPlanWorkunit> calPlanWorkunitQueryWrapper = new QueryWrapper<>();
            calPlanWorkunitQueryWrapper.eq("t1.is_work", calCalendar.getIsWork());
            calPlanWorkunitQueryWrapper.in("t1.workunit_id", calCalendar.getWorkunitIds());
            calPlanWorkunitQueryWrapper.eq("t1.the_day", cal.getTheDay());
//            calPlanWorkunitQueryWrapper.eq("t1.rest_flag", calCalendar.getRestFlag());
            List<CalPlanWorkunit> calPlanWorkunits = calPlanWorkunitMapper.selectListByQw(calPlanWorkunitQueryWrapper);
            Map<String, List<CalPlanWorkunit>> groupBy = calPlanWorkunits.stream().collect(Collectors.groupingBy(x -> x.getWorkunitId() + ":" + x.getShiftName()));

            List<CalPlanWorkunit> resultCalPlanWorkunits = new ArrayList<>();
            for (Map.Entry<String, List<CalPlanWorkunit>> entry : groupBy.entrySet()) {
                //获取当天的时间
                switch ( entry.getValue().get(0).getShiftName()){
                    case "白班":
                        String s = CalPlanWorkunitUp(entry);
                        entry.getValue().get(0).setWorkDate(s);
                        break;
                    case "中班":
                        String s1 = CalPlanWorkunitCentre(entry);
                        entry.getValue().get(0).setWorkDate(s1);
                        break;
                    case "夜班":
                        String s2 = CalPlanWorkunitCentre(entry);
                        entry.getValue().get(0).setWorkDate(s2);
                        break;
                    default:
                        break;
                }
                resultCalPlanWorkunits.add(entry.getValue().get(0));
            }
            if (CollUtil.isNotEmpty(resultCalPlanWorkunits)) {
                cal.setCalPlanWorkunitList(resultCalPlanWorkunits);
                cal.setShiftType(resultCalPlanWorkunits.get(0).getShiftType());
                cal.setHolidayType("WORKDAY");
            } else {
                cal.setHolidayType("HOLIDAY");
            }
        }
        return calendars;
    }


    @Override
    public List<CalCalendar> dayList(Date day, CalCalendar calCalendar) {
        List<CalCalendar> calendars = MesCalendarUtil.getDays(day);
        for (CalCalendar cal : calendars) {
            List<CalShiftVo> calShiftVos = new ArrayList<>();
            String theDay = cal.getTheDay();
            if (theDay != null) {
                QueryWrapper<CalShiftVo> wrapper = new QueryWrapper<>();
//                wrapper.eq("ash.is_work", calCalendar.getIsWork());
                wrapper.eq(StringUtils.isNotEmpty(calCalendar.getWorkunitName()), "mw.workunit_name", calCalendar.getWorkunitName());
                wrapper.eq("cpw.the_day", theDay);
                wrapper.last("limit 1");
                calShiftVos = calShiftMapper.selectOnWorkShiftByQw(wrapper);
            }

            if (CollUtil.isNotEmpty(calShiftVos)) {
                cal.setShiftType(calShiftVos.get(0).getShiftType());
                cal.setHolidayType("WORKDAY");
            } else {
                cal.setHolidayType("HOLIDAY");
            }
        }
        return calendars;
    }


    @Override
    public List<CalCalendar> getCalendarByWorkunit(Date day, CalCalendar calCalendar) {
        List<CalCalendar> calendars = MesCalendarUtil.getDays(day);
        for (CalCalendar cal : calendars) {
            MdWorkunit mdWorkunit1 = new MdWorkunit();
            mdWorkunit1.setWorkunitId(calCalendar.getWorkunitId());
            mdWorkunitMapper.selectMdWorkunitLists(mdWorkunit1);
            CalPlanWorkunit param = new CalPlanWorkunit();
            param.setIsWork(calCalendar.getIsWork());
            param.setTheDay(cal.getTheDay());
            if (calCalendar.getWorkunitName() != null && calCalendar.getWorkunitId() != null) {
                param.setWorkunitName(calCalendar.getWorkunitName());
                param.setWorkunitId(calCalendar.getWorkunitId());
            }

            List<CalPlanWorkunit> calPlanWorkunits = calPlanWorkunitMapper.selectCalPlanWorkunitListV2(param);
            Map<String, List<CalPlanWorkunit>> groupBy = calPlanWorkunits.stream().collect(Collectors.groupingBy(x -> x.getWorkunitId() + ":" + x.getShiftName()));

            List<CalPlanWorkunit> resultCalPlanWorkunits = new ArrayList<>();
            for (Map.Entry<String, List<CalPlanWorkunit>> entry : groupBy.entrySet()) {
                   //获取当天的时间
                    switch ( entry.getValue().get(0).getShiftName()){
                        case "白班":
                            String s = CalPlanWorkunitUp(entry);
                            entry.getValue().get(0).setWorkDate(s);
                            break;
                        case "中班":
                            String s1 = CalPlanWorkunitCentre(entry);
                            entry.getValue().get(0).setWorkDate(s1);
                            break;
                        case "夜班":
                            String s2 = CalPlanWorkunitCentre(entry);
                            entry.getValue().get(0).setWorkDate(s2);
                            break;
                        default:
                            break;
                    }

                    resultCalPlanWorkunits.add(entry.getValue().get(0));
            }

            if (CollUtil.isNotEmpty(resultCalPlanWorkunits)) {
                cal.setCalPlanWorkunitList(resultCalPlanWorkunits);
                cal.setShiftType(resultCalPlanWorkunits.get(0).getShiftType());
                cal.setHolidayType("WORKDAY");
            } else {
                cal.setHolidayType("HOLIDAY");
            }
        }
        return calendars;
    }


    //白天的时间拼接
    public String CalPlanWorkunitUp(Map.Entry<String, List<CalPlanWorkunit>> entry){
        Date startDate = entry.getValue().get(0).getStartDate();
        Date endDate = entry.getValue().get(0).getEndDate();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDates= formatter.format(startDate);
        String endDates = formatter.format(endDate);
        String a=startDates+"--"+endDates+"\n";
        Date startDate1 = entry.getValue().get(1).getStartDate();
        Date endDate1 = entry.getValue().get(1).getEndDate();
        String startDates1= formatter.format(startDate1);
        String endDates1 = formatter.format(endDate1);
        String b=startDates1+"--"+endDates1+"\n";
        Date startDate2 = entry.getValue().get(2).getStartDate();
        Date endDate2 = entry.getValue().get(2).getEndDate();
        String startDates2= formatter.format(startDate2);
        String endDates2 = formatter.format(endDate2);
        String c=startDates2+"--"+endDates2;
       return a+b+c;
    }

    //中班和中班
    public String CalPlanWorkunitCentre(Map.Entry<String, List<CalPlanWorkunit>> entry){
        Date startDate = entry.getValue().get(0).getStartDate();
        Date endDate = entry.getValue().get(0).getEndDate();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDates= formatter.format(startDate);
        String endDates = formatter.format(endDate);
        String a=startDates+"--"+endDates;
        return a;
    }

    private List<CalPlanWorkunit> queryCalendarMountData(CalPlanWorkunit calPlanWorkunit) {
        List<CalPlanWorkunit> calPlanWorkunits = calPlanWorkunitMapper.selectCalPlanWorkunitListV2(calPlanWorkunit);
        Map<String, List<CalPlanWorkunit>> groupBy = calPlanWorkunits.stream().collect(Collectors.groupingBy(x -> x.getWorkunitId() + ":" + x.getShiftName()));
        List<CalPlanWorkunit> resultList = new ArrayList<>();
        for (Map.Entry<String, List<CalPlanWorkunit>> entry : groupBy.entrySet()) {
            resultList.add(entry.getValue().get(0));
        }
        return resultList;
    }


}
