package com.ximai.mes.cal.service;

import java.util.List;

import com.ximai.mes.cal.domain.CalPlan;
import com.ximai.mes.cal.domain.CalTeamshift;
import org.springframework.scheduling.annotation.Async;

/**
 * 班组排班Service接口
 *
 * @date 2022-06-11
 */
public interface ICalTeamshiftService {
    /**
     * 查询班组排班
     *
     * @param recordId 班组排班主键
     * @return 班组排班
     */
    CalTeamshift selectCalTeamshiftByRecordId(Long recordId);

    /**
     * 查询班组排班列表
     *
     * @param calTeamshift 班组排班
     * @return 班组排班集合
     */
    List<CalTeamshift> selectCalTeamshiftList(CalTeamshift calTeamshift);

    /**
     * 新增班组排班
     *
     * @param calTeamshift 班组排班
     * @return 结果
     */
    int insertCalTeamshift(CalTeamshift calTeamshift);

    /**
     * 修改班组排班
     *
     * @param calTeamshift 班组排班
     * @return 结果
     */
    int updateCalTeamshift(CalTeamshift calTeamshift);

    /**
     * 批量删除班组排班
     *
     * @param recordIds 需要删除的班组排班主键集合
     * @return 结果
     */
    int deleteCalTeamshiftByRecordIds(Long[] recordIds);

    /**
     * 删除班组排班信息
     *
     * @param recordId 班组排班主键
     * @return 结果
     */
    int deleteCalTeamshiftByRecordId(Long recordId);


    @Async
    void genRecords(Long plandId);
}
