package com.ximai.mes.cal.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 计划工作单元对象 cal_workunit
 *
 * @author generator
 * @date 2024-03-14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "排班工作单元实体")
public class CalWorkunit extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 主键ID
     */
    @TableId
    private Long id;


    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划ID", required = true)
    @Excel(name = "计划ID")
    private Long planId;

    private String planCode;
    /**
     * 工作单元ID
     */
    @ApiModelProperty(value = "工作单元ID", required = true)
    @Excel(name = "工作单元ID")
    private Long workunitId;

    /**
     * 工作单元编号
     */
    @ApiModelProperty(value = "工作单元编号", required = true)
    @Excel(name = "工作单元编号")
    private String workunitCode;

    /**
     * 工作单元名称
     */
    @ApiModelProperty(value = "工作单元名称", required = true)
    @Excel(name = "工作单元名称")
    private String workunitName;


    @TableField(exist = false)
    private String workstationId;

    @TableField(exist = false)
    private String workstationCode;

    @TableField(exist = false)
    private String workstationName;

    @TableField(exist = false)
    private String workshopId;
    @TableField(exist = false)
    private String workshopCode;
    @TableField(exist = false)
    private String workshopName;

    @TableField(exist = false)
    private String factoryId;
    @TableField(exist = false)
    private String factoryCode;
    @TableField(exist = false)
    private String factoryName;


}
