package com.ximai.mes.cal.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 计划班次对象 cal_shift
 *
 * @date 2022-06-06
 */
//@ApiModel(description = "班次实体")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CalShift extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private int restFlag = 0;
    @TableField(exist = false)
    private Integer nextDay;


    /**
     * 班次ID
     */
    @ApiModelProperty(value = "班次id")
    private Long shiftId;


    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划id")
    @Excel(name = "计划ID")
    private Long planId;

    private String planCode;
    private String planName;

    @ApiModelProperty(value = "排列顺序")
    /**
     * 序号
     */
    @Excel(name = "序号")
    private Integer orderNum;

    /**
     * 班次名称
     */
    @ApiModelProperty(value = "班次名称")
    @Excel(name = "班次名称")
    private String shiftName;

    @ApiModelProperty(value = "班次类型")
    @Excel(name = "班次类型")
    private String shiftType;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    @Excel(name = "开始时间")
    private String startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    @Excel(name = "结束时间")
    private String endTime;

//
//    /**
//     * 开始时间
//     */
//    @ApiModelProperty(value = "开始时间")
//    @Excel(name = "开始时间")
//    private Date startDate;
//
//    /**
//     * 结束时间
//     */
//    @ApiModelProperty(value = "结束时间")
//    @Excel(name = "结束时间")
//    private Date endDate;

    @ApiModelProperty(value = "休息开始时间")
    private String breakStartTime;

    @ApiModelProperty(value = "休息结束时间")
    private String breakEndTime;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    private Integer operType;

    private List<CalShift> breakTimeList = new ArrayList<>();


    private Date execStartTime;
    private Date execEndTime;
}
