package com.ximai.mes.cal.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 计划工作单元对象 cal_plan_workunit
 *
 * @author generator
 * @date 2024-03-14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "工作单元排班记录实体")
public class CalPlanWorkunit extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public CalPlanWorkunit(Long planId) {
        this.planId = planId;
    }

    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划id")
    @Excel(name = "计划ID")
    private Long planId;
    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划id")
    @Excel(name = "计划ID")
    private String planCode;


    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划id")
    @Excel(name = "计划ID")
    private String planName;
    @ApiModelProperty(value = "班次类型")
    private String shiftType;

    @ApiModelProperty(value = "班次id")
    private Long shiftId;

    @ApiModelProperty(value = "班次名称")
    private String shiftName;

    private String theDay;

    @ApiModelProperty(value = "是否工作")
    private Integer isWork;

    /**
     * 主键ID
     */
    @TableId
    private Long id;

    /**
     * 工作单元ID
     */
    @ApiModelProperty(value = "工作单元id")
    @Excel(name = "工作单元ID")
    private Long workunitId;

    /**
     * 工作单元编号
     */
    @ApiModelProperty(value = "工作单元编号")
    @Excel(name = "工作单元编号")
    private String workunitCode;

    /**
     * 工作单元名称
     */
    @ApiModelProperty(value = "工作单元名称")
    @Excel(name = "工作单元名称")
    private String workunitName;

    @TableField(exist = false)
    private String workstationName;

    @TableField(exist = false)
    private String workshopName;

    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1")
    private String attr1;

    /**
     * 预留字段2
     */
    @Excel(name = "预留字段2")
    private String attr2;

    /**
     * 预留字段3
     */
    @Excel(name = "预留字段3")
    private Long attr3;

    /**
     * 预留字段4
     */
    @Excel(name = "预留字段4")
    private Long attr4;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    @Excel(name = "开始时间")
    private Date startDate;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    @Excel(name = "结束时间")
    private Date endDate;

    /**
     * 开始数据和结束时间
     */
    @TableField(exist = false)
    private String workDate;


//    /**
//     * 开始时间
//     */
//    @ApiModelProperty(value = "开始时间")
//    @Excel(name = "开始时间")
//    private String startTime;
//
//    /**
//     * 结束时间
//     */
//    @ApiModelProperty(value = "结束时间")
//    @Excel(name = "结束时间")
//    private String endTime;
//
//    @ApiModelProperty(value = "休息开始时间")
//    private String breakStartTime;
//
//    @ApiModelProperty(value = "休息结束时间")
//    private String breakEndTime;

    private int restFlag = 0;

}
