package com.ximai.mes.cal.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.service.ICalPlanWorkunitService;
import com.ximai.mes.constant.CalPlanWorkunitEnum;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 计划工作单元Controller
 *
 * @author generator
 * @date 2024-03-14
 */
@RestController
@RequestMapping("/md/cal/plan/workunit")
public class CalPlanWorkunitController extends BaseController {
    @Autowired
    private ICalPlanWorkunitService calPlanWorkunitService;

    /**
     * 查询计划工作单元列表
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:list')")
    @GetMapping("/list")
    public TableDataInfo list(CalPlanWorkunit calPlanWorkunit) {
        startPage();
        List<CalPlanWorkunit> list = calPlanWorkunitService.selectCalPlanWorkunitList(calPlanWorkunit);
        return getDataTable(list);
    }

    /**
     * 获取计划工作单元详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:query')")
    @GetMapping(value = "/{planWorkunitId}")
    public AjaxResult getInfo(@PathVariable("planWorkunitId") Long planWorkunitId) {
        return AjaxResult.success(calPlanWorkunitService.selectCalPlanWorkunitByPlanWorkunitId(planWorkunitId));
    }

    /**
     * 新增计划工作单元
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:add')")
    @Log(title = "计划工作单元新增", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CalPlanWorkunit calPlanWorkunit) {
        return toAjax(calPlanWorkunitService.insertCalPlanWorkunit(calPlanWorkunit));
    }

    /**
     * 新增计划工作单元
     */
    @ApiOperation("批量新增排班")
    @PreAuthorize("@ss.hasPermi('md:workunit:add')")
    @Log(title = "批量新增排班", businessType = BusinessType.INSERT)
    @PostMapping(value = "/addList")
    public AjaxResult addList(@RequestBody List<CalPlanWorkunit> calPlanWorkunit) {

        long count = calPlanWorkunit.stream().filter(x -> x.getWorkunitId() == null || x.getTheDay() == null || x.getTheDay() == "").count();
        if (count > 0) {
            throw new RuntimeException("请传递正确的工作单元和当前时间");
        }

        for (CalPlanWorkunit planWorkunit : calPlanWorkunit) {
            // 删除同一天在同一个工作单元已经粗在上的旧数据
            QueryWrapper<CalPlanWorkunit> eq = new QueryWrapper<>();
            eq.eq("workunid_id", planWorkunit.getWorkunitId());
            eq.eq("the_day", planWorkunit.getTheDay());
            calPlanWorkunitService.delete(eq);
            planWorkunit.setIsWork(CalPlanWorkunitEnum.YES.getType());
            calPlanWorkunitService.insertCalPlanWorkunit(planWorkunit);
        }
        return AjaxResult.success();
    }

    /**
     * 修改计划工作单元
     */
    @ApiOperation("批量更新排班")
    @PreAuthorize("@ss.hasPermi('md:workunit:edit')")
    @Log(title = "计划工作单元", businessType = BusinessType.UPDATE)
    @PutMapping(value = "/editList")
    public AjaxResult editList(@RequestBody List<CalPlanWorkunit> calPlanWorkunits) {
        ExceptionUtil.checkTrueThrowException(CollectionUtil.isEmpty(calPlanWorkunits), "没有指定放假对象");

        long count = calPlanWorkunits.stream().filter(
                x -> x.getWorkunitId() == null ||
                        x.getTheDay() == null ||
                        x.getShiftName() == null ||
                        x.getIsWork() == null).count();
        ExceptionUtil.checkTrueThrowException(count > 0, "非法的更新数据");

        // workunit_id,the_day,shift_name
        for (CalPlanWorkunit calPlanWorkunit : calPlanWorkunits) {
            calPlanWorkunitService.updateCalPlanWorkunitWorkStatus(calPlanWorkunit);
        }

        return AjaxResult.success();

    }

    /**
     * 修改计划工作单元
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:edit')")
    @Log(title = "计划工作单元", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CalPlanWorkunit calPlanWorkunit) {
        return toAjax(calPlanWorkunitService.updateCalPlanWorkunit(calPlanWorkunit));
    }

    /**
     * 删除计划工作单元
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:remove')")
    @Log(title = "计划工作单元删除", businessType = BusinessType.DELETE)
    @DeleteMapping("/{planWorkunitIds}")
    public AjaxResult remove(@PathVariable Long[] planWorkunitIds) {
        return toAjax(calPlanWorkunitService.deleteListByIds(planWorkunitIds));
    }
}
