package com.ximai.mes.util;

import com.ximai.common.exception.ServiceException;

import java.math.BigDecimal;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/22
 */
public class QrCodeParseUtil {
    /**
     * 解析包装标签
     * 1)第1~6位：共6位数，还是取供应商的编码，不变；
     * 2)第7~12位：共6位数，按YYMMDD取“CPUDT”字段的日期。相对于之前YYYYMMDD的8位数，缩减两位
     * 3)第13~18位：共6位数，版号（卷号），还是取操作界面中的字段“PACKNO”的值。内容不变，位数前移2位
     * 4)第19位：分界号，|。内容不变，位数前移2位
     * 5)第20~29位：10位数，还是物料编号（MATNR）。
     * 6)第30~40位：11位数，每个版号（卷号）的数量，还是取字段PACMG。按最大数量9,999,999.999，小数点前7位（百万级，RFID工厂的芯片完全可能达到这个数量级），小数点本身占据1位，小数点后3位；
     * 7)第41位：分界号，|
     * 8)第42~45位：本次新增，工厂代码（WERKS）
     * 9)第45~55位：本共10位，批次号（CHARG）
     * 10)第53位~80位：预留以备未来扩展。例如GRS、FSC审计对再生性材料以及使用再生材料制造的产成品都存在对其重量的审计要求要求，这个重量有可能就是回收类材料的基本单位，但也可能不是基本单位，而是每个的单位重量。毛重、净重加上重量单位，至少两个信息含在其中
     *
     * @param code
     * @return
     */
    public static PackQrInfo parsePackQr(String code) {
        code = code.replace("|", "");
        int length = code.length();
        if (length < 50) {
            throw new ServiceException("编码长度不够");
        }
// 1000200615000001|00010001000000005.000|10002461500001
        PackQrInfo packQrInfo = new PackQrInfo();
        packQrInfo.supplierNo = code.substring(0, 6);
        packQrInfo.dateStr = code.substring(6, 10);
        packQrInfo.packNo = code.substring(10, 16);
        packQrInfo.matnr = "00000000" + code.substring(16, 26);
        packQrInfo.pacmg = new BigDecimal(code.substring(26, 37));
        packQrInfo.werks = code.substring(37, 41);
        String substring = code.substring(41, length);
        packQrInfo.batchNo = substring;
        return packQrInfo;
    }


}
