package com.ximai.mes.tm.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.tm.domain.TmToolRequestUse;
import com.ximai.mes.tm.service.ITmToolRequestUseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 刀模版领用单Controller
 *
 * @author generator
 * @date 2024-02-02
 */
@RestController
@RequestMapping("/tm/tmToolRequestUse")
public class TmToolRequestUseController extends BaseController {
    @Autowired
    private ITmToolRequestUseService tmToolRequestUseService;

    /**
     * 查询刀模版领用单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolRequestUse tmToolRequestUse) {
        startPage();
        List<TmToolRequestUse> list = tmToolRequestUseService.selectTmToolRequestUseList(tmToolRequestUse);
        return getDataTable(list);
    }

    /**
     * 导出刀模版领用单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:export')")
    @Log(title = "刀模版领用单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, TmToolRequestUse tmToolRequestUse) {
        List<TmToolRequestUse> list = tmToolRequestUseService.selectTmToolRequestUseList(tmToolRequestUse);
        ExcelUtil<TmToolRequestUse> util = new ExcelUtil<TmToolRequestUse>(TmToolRequestUse.class);
        util.exportExcel(response, list, "刀模版领用单数据");
    }

    /**
     * 获取刀模版领用单详细信息
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:query')")
    @GetMapping(value = "/{toolRequestUseId}")
    public AjaxResult getInfo(@PathVariable("toolRequestUseId") Long toolRequestUseId) {
        return AjaxResult.success(tmToolRequestUseService.selectTmToolRequestUseByToolRequestUseId(toolRequestUseId));
    }

    /**
     * 新增刀模版领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:add')")
    @Log(title = "刀模版领用单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolRequestUse tmToolRequestUse) {
        return toAjax(tmToolRequestUseService.insertObj(tmToolRequestUse));
    }

    /**
     * 修改刀模版领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:edit')")
    @Log(title = "刀模版领用单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolRequestUse tmToolRequestUse) {
        return toAjax(tmToolRequestUseService.updateObj(tmToolRequestUse));
    }

    /**
     * 删除刀模版领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUse:remove')")
    @Log(title = "刀模版领用单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolRequestUseIds}")
    public AjaxResult remove(@PathVariable Long[] toolRequestUseIds) {
        return toAjax(tmToolRequestUseService.deleteTmToolRequestUseByToolRequestUseIds(toolRequestUseIds));
    }

    /**
     * 通过申请单id获取领用单勾选工装夹具列表
     */
    @GetMapping(value = "/getToolsBytoolRequestId/{toolRequestId}")
    public AjaxResult getToolsBytoolRequestId(@PathVariable("toolRequestId") Long toolRequestId) {
        return AjaxResult.success(tmToolRequestUseService.selectTmToolsByToolRequestId(toolRequestId));
    }


//    /**
//     * 通过工序和编排单号获取领用单工装夹具列表
//     */
//    @PutMapping(value = "/getToolsByProcessIdAndArrangeCode")
//    public AjaxResult getToolsByProcessIdAndArrangeCode(@RequestBody TmToolRequestUse tmToolRequestUse) {
//        return AjaxResult.success(tmToolRequestUseService.getToolsByProcessIdAndArrangeCode(tmToolRequestUse));
//    }
}
