package com.ximai.mes.tm.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.constant.TmToolMachineTypeEnum;
import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.service.ITmToolMachinesService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 刀模版上下机Controller
 *
 * @author generator
 * @date 2024-02-06
 */
@RestController
@RequestMapping("/tm/tmToolMachines")
public class TmToolMachinesController extends BaseController {
    @Autowired
    private ITmToolMachinesService tmToolMachinesService;


    /**
     * 查询刀模版上下机列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolMachines tmToolMachines) {
        startPage();
        List<TmToolMachines> list = tmToolMachinesService.selectTmToolMachinesVoList(tmToolMachines);
        return getDataTable(list);
    }

    /**
     * 查询刀模版上下机列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:list')")
    @GetMapping("/warehouse/list")
    public TableDataInfo warehouselist(TmToolMachines tmToolMachines) {
        startPage();
        List<TmToolMachines> collect = tmToolMachinesService.selectTmToolMachinesVoList(tmToolMachines);
        List<TmToolMachines> list = collect.stream().filter(s -> StringUtils.isNotEmpty(s.getToolRequestUseId())).collect(Collectors.toList());
        Set<String> objects = new HashSet<>();
        List<TmToolMachines> objects1 = new ArrayList<>();
        for (TmToolMachines machines : list) {
            if (objects.add(machines.getToolCode())) {
                if (StringUtils.isNotEmpty(machines.getToolRequestUseId())) {
                    if (!Objects.equals(machines.getType(), TmToolMachineTypeEnum.MOUNT.getType())) {
                        objects1.add(machines);
                    }
                }
            }
        }
        return getDataTable(objects1);
    }


    /**
     * 导出刀模版上下机列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:export')")
    @Log(title = "刀模版上下机", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, TmToolMachines tmToolMachines) {
        List<TmToolMachines> list = tmToolMachinesService.selectTmToolMachinesList(tmToolMachines);
        ExcelUtil<TmToolMachines> util = new ExcelUtil<TmToolMachines>(TmToolMachines.class);
        util.exportExcel(response, list, "刀模版上下机数据");
    }

    /**
     * 获取刀模版上下机详细信息
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:query')")
    @GetMapping(value = "/{toolMachinesId}")
    public AjaxResult getInfo(@PathVariable("toolMachinesId") Long toolMachinesId) {
        return AjaxResult.success(tmToolMachinesService.selectTmToolMachinesByToolMachinesId(toolMachinesId));
    }

    /**
     * 新增刀模版上下机
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:add')")
    @Log(title = "新增刀模版上下机", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolMachines tmToolMachines) {
        tmToolMachinesService.insertObj(tmToolMachines);
        return AjaxResult.success();
    }

    /**
     * 修改刀模版上下机
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:edit')")
    @Log(title = "修改刀模版上下机", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody List<TmToolMachines> tmToolMachinesList) {
        return toAjax(tmToolMachinesService.updateBindStatus(tmToolMachinesList));
    }

    /**
     * 删除刀模版上下机
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachines:remove')")
    @Log(title = "删除刀模版上下机", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolMachinesIds}")
    public AjaxResult remove(@PathVariable Long[] toolMachinesIds) {
        return toAjax(tmToolMachinesService.deleteTmToolMachinesByToolMachinesIds(toolMachinesIds));
    }

    /**
     * 修改生产任务状态
     */
    @ApiOperation("刀模版扫码上机接口")
    @Log(title = "刀模版扫码上机接口", businessType = BusinessType.UPDATE)
    @PostMapping("/scancode")
    @ResponseBody
    public AjaxResult scanCode(@RequestBody TmToolMachines machines) {
        return toAjax(tmToolMachinesService.scanCode(machines));
    }


    /**
     * 修改生产任务状态
     */
    @ApiOperation("检测工序用板弹窗")
    @Log(title = "检测工序用板弹窗", businessType = BusinessType.UPDATE)
    @PostMapping("/checkIsExsitToolWindow")
    @ResponseBody
    public AjaxResult checkIsExistToolWindow(@RequestBody TmToolMachines machines) {
        return AjaxResult.success(tmToolMachinesService.checkIsExistToolWindow(machines));
    }

}
