package com.ximai.mes.restful.bpm;

import com.alibaba.fastjson.JSON;
import com.ximai.mes.bpm.BpmService;
import com.ximai.system.domain.vo.PersonVo;
import com.ximai.system.domain.vo.SysOrgUserVo;
import com.ximai.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 人员管理拉取
 */

@Component
public class UserPulling {

    @Autowired
    private BpmService bpmService;

    @Autowired
    private ISysUserService sysUserService;


//    @Scheduled(fixedDelay = 34560,timeUnit = TimeUnit.SECONDS)
//    @Scheduled(cron = "0 0/4 16 * * ?")
    @Scheduled(cron = "0 0 23 * * ?")
    @Transactional
    public void user(){
        String userString = bpmService.sysSysOrg();
        SysOrgUserVo javaObject = JSON.parseObject(userString).toJavaObject(SysOrgUserVo.class);
        List<PersonVo> personVoList = javaObject.getPersonVoList();
        sysUserService.userCreate(personVoList);
    }




}
