package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.bpm.BpmService;
import com.ximai.system.domain.vo.PersonVo;
import com.ximai.system.domain.vo.SysOrgUserVo;
import com.ximai.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@RestController
@RequestMapping(value = "/system/usermanage")
public class UserManageRestController extends BaseController {

    @Autowired
    private ISysUserService sysUserService;

    @Autowired
    private BpmService bpmService;




    @Log(title = "bpm人员创建", businessType = BusinessType.INSERT)
    @PostMapping("/userManageCreate")
    public AjaxResult userManageCreate() {
        String userString = bpmService.sysSysOrg();
        SysOrgUserVo javaObject = JSON.parseObject(userString).toJavaObject(SysOrgUserVo.class);
        List<PersonVo> personVoList = javaObject.getPersonVoList();
        sysUserService.userCreate(personVoList);
        return AjaxResult.success("已完成同步");
    }


}
