package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ximai.common.annotation.Log;
import com.ximai.common.constant.Constants;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.domain.SapAjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import com.ximai.mes.pro.service.task.IProTaskAssistProcessService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工序任务外协关系Controller
 *
 * @author generator
 * @date 2024-03-29
 */
@Slf4j
@RestController
@RequestMapping("/api/v1/assistprocess")
public class TaskAssistProcessRestController extends BaseController {

    @Autowired
    private IProTaskAssistProcessService proTaskAssistProcessService;
    
    /**
     * 导出工序任务外协关系列表
     */
    @BasicAuth
    @Log(title = "sap外协操作", businessType = BusinessType.INSERT)
    @RequestMapping(value = "/sapapi", method = RequestMethod.POST)
    public SapAjaxResult sapapi(@RequestBody String assistProcess) {
        log.info("外协请求同步: " + JSONObject.toJSONString(assistProcess));

        ProTaskAssistProcess proTaskAssistProcess = JSON.parseObject(assistProcess, ProTaskAssistProcess.class);
        int resultcode = 0;
        try {
            switch (proTaskAssistProcess.getActionType()) {
                case Constants.METHOD_INSERT_TYPE:
                    resultcode = proTaskAssistProcessService.insertObj(proTaskAssistProcess);
                    break;
                case Constants.METHOD_UPDATE_TYPE:
                    resultcode = proTaskAssistProcessService.updateObj(proTaskAssistProcess);
                    break;
                case Constants.METHOD_DELETE_TYPE:
                    resultcode = proTaskAssistProcessService.deleteObj(proTaskAssistProcess);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            return SapAjaxResult.error(e.getMessage());
        }

        return sapToAjax(resultcode);

    }

    /**
     * 导出工序任务外协关系列表
     */
    @BasicAuth
    @Log(title = "工序任务外协关系", businessType = BusinessType.DELETE)
//    @PutMapping("/delete")
    @RequestMapping(value = "/delete", method = RequestMethod.PUT)
    public void delete(@RequestBody ProTaskAssistProcess proTaskAssistProcess) {
        proTaskAssistProcessService.deleteObj(proTaskAssistProcess);
    }


    /**
     * 新增工序任务外协关系
     */
    @BasicAuth
    @Log(title = "工序任务外协关系", businessType = BusinessType.INSERT)
//    @PostMapping(value = "/addAssistProcess")
    @RequestMapping(value = "/addAssistProcess", method = RequestMethod.POST)
    public AjaxResult addAssistProcess(@RequestBody ProTaskAssistProcess proTaskAssistProcess) {
        return toAjax(proTaskAssistProcessService.insertObj(proTaskAssistProcess));
    }


    /**
     * 修改工序任务外协关系
     */
    @BasicAuth
    @Log(title = "工序任务外协关系", businessType = BusinessType.UPDATE)
//    @PutMapping(value = "/updateAssistProcess")
    @RequestMapping(value = "/updateAssistProcess", method = RequestMethod.PUT)
    public AjaxResult updateAssistProcess(@RequestBody ProTaskAssistProcess proTaskAssistProcess) {
        return toAjax(proTaskAssistProcessService.updateObj(proTaskAssistProcess));
    }


}
