package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.face.sap.SapService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * title: sap pad 相关接口封装
 * author: chicheng.li
 * date:2024/3/18
 * description:
 */
@RestController
@RequestMapping(value = "/sap/trans")
public class SapPdaRestController {

    @Autowired
    private SapService sapService;

    @ApiOperation(value = "销售交货单过账")
    @RequestMapping(value = "/post_delv", method = RequestMethod.POST)
    public AjaxResult syncPostDelv(@RequestBody String json) {
        String rst = sapService.syncPostDelv(json);
        Map<String, Object> map = JSON.parseObject(rst, new TypeReference<Map<String, Object>>() {
        });
        return AjaxResult.success(map);
    }

    @ApiOperation(value = "采购入库扫描")
    @RequestMapping(value = "/get_mm_plnr/plnr", method = RequestMethod.POST)
    public AjaxResult getMmPlnrPlnr(@RequestBody String json) {
        String rst = sapService.getMmPlnrPlnr(json);
        Map<String, Object> map = JSON.parseObject(rst, new TypeReference<Map<String, Object>>() {
        });
        return AjaxResult.success(map);
    }

}
